// ##################################################
// ###              TOBII_SERVER_CPP              ###
// ##################################################
#ifndef TOBII_SERVER_CPP
#define TOBII_SERVER_CPP

// ##################################################
// ###                 DEPENDENCES                ###
// ##################################################

#include "TobiiSDK.hpp"

// ##################################################
// ###              NAMESPACE TOBII               ###
// ##################################################
namespace Tobii {

	// ##################################################
	// ###                CLASS TOBIISDK              ###
	// ##################################################

	TobiiSDK::TobiiSDK ( Int64 windowSize, bool keepAllPackets, bool forceInterpolation, bool forceComputingDistance, DevicePtr ptrDevice, QObject* parent )
	: Recorder( windowSize, keepAllPackets, forceInterpolation, forceComputingDistance, parent ), _sdkFinished( false )
	{
		this->setPtrDevice( ptrDevice );
		this->connectSlots();
	}

	TobiiSDK::~TobiiSDK ()
	{}

	void TobiiSDK::connectSlots ()
	{
		qRegisterMetaType<Tobii::FramePtr       >( "FramePtr"        );
		qRegisterMetaType<Tobii::GazeFixationPtr>( "GazeFixationPtr" );
		qRegisterMetaType<Tobii::OrientationPtr >( "OrientationPtr"  );
		qRegisterMetaType<Tobii::AccelerationPtr>( "AccelerationPtr" );

		connect( this, SIGNAL( orientationRecorded(OrientationPtr          )), this, SLOT( receiveOrientation(OrientationPtr          )), Qt::DirectConnection );
		connect( this, SIGNAL(accelerationRecorded(AccelerationPtr         )), this, SLOT(receiveAcceleration(AccelerationPtr         )), Qt::DirectConnection );
		connect( this, SIGNAL(   frameInterpolated(FramePtr,GazeFixationPtr)), this, SLOT(  receiveSynkedData(FramePtr,GazeFixationPtr)), Qt::DirectConnection );
		connect( this, SIGNAL(            finished()                        ), this, SLOT(    readingFinished()                        ), Qt::DirectConnection );
	}

	const DevicePtr& 		TobiiSDK::ptrDevice 		() const	{ return this->_ptrDevice;			}
	DevicePtr&		 		TobiiSDK::ptrDevice 		()			{ return this->_ptrDevice;			}
	const cv::Size&			TobiiSDK::resolution		() const	{ return this->ptrDevice()->resolution();	}
	cv::Size&				TobiiSDK::resolution		()			{ return this->ptrDevice()->resolution();	}
	const QMutex&			TobiiSDK::mutex				() const	{ return this->_mutex;				}
	QMutex&					TobiiSDK::mutex				()			{ return this->_mutex;				}
	bool					TobiiSDK::hasFinished		() const	{ return this->_sdkFinished;		}
	bool&					TobiiSDK::hasFinished		()			{ return this->_sdkFinished;		}
	const FramePtr&			TobiiSDK::ptrFrame			() const	{ return this->_ptrFrame;			}
	FramePtr&				TobiiSDK::ptrFrame			()			{ return this->_ptrFrame;			}
	const GazeFixationPtr&	TobiiSDK::ptrFixation		() const	{ return this->_ptrFixation;		}
	GazeFixationPtr&		TobiiSDK::ptrFixation		()			{ return this->_ptrFixation;		}
	const AccelerationPtr&	TobiiSDK::ptrAcceleration	() const	{ return this->_ptrAcceleration;	}
	AccelerationPtr&		TobiiSDK::ptrAcceleration	()			{ return this->_ptrAcceleration;	}
	const OrientationPtr&	TobiiSDK::ptrOrientation	() const	{ return this->_ptrOrientation;		}
	OrientationPtr&			TobiiSDK::ptrOrientation	()			{ return this->_ptrOrientation;		}

	void TobiiSDK::deviceFinished()
	{
		emit this->finished();
	}

	void TobiiSDK::setPtrDevice ( DevicePtr ptrDevice )
	{
		if ( ptrDevice )
		{
			// Disconnect previous device
			if ( this->ptrDevice() )
			{
				disconnect( this->ptrDevice().get(), SIGNAL( dataAvailable(DataPacketPtr)), this, SLOT(    recordData(DataPacketPtr)) );
				disconnect( this->ptrDevice().get(), SIGNAL(frameAvailable(FramePtr)     ), this, SLOT(   recordFrame(FramePtr)     ) );
				disconnect( this->ptrDevice().get(), SIGNAL(      finished()             ), this, SLOT(deviceFinished()             ) );
			}

			// Connect the new one
			this->ptrDevice() = ptrDevice;
			connect( this->ptrDevice().get(), SIGNAL( dataAvailable(DataPacketPtr)), this, SLOT(    recordData(DataPacketPtr)), Qt::DirectConnection );
			connect( this->ptrDevice().get(), SIGNAL(frameAvailable(FramePtr)     ), this, SLOT(   recordFrame(FramePtr)     ), Qt::DirectConnection );
			connect( this->ptrDevice().get(), SIGNAL(      finished()             ), this, SLOT(deviceFinished()             ), Qt::DirectConnection );
		}
	}

	void TobiiSDK::startReading ( const QString& arg1, const QString& arg2 )
	{
		if ( this->ptrDevice() )
			this->ptrDevice()->startReading( arg1, arg2 );
		else
			std::cerr << "TobiiSDK::startReading(): no device has been set" << std::endl << std::flush;
	}

	void TobiiSDK::finishReading ()
	{
		if ( this->ptrDevice() )
			this->ptrDevice()->finishReading();
		else
			std::cerr << "TobiiSDK::finishReading(): no device has been set" << std::endl << std::flush;
	}

	void TobiiSDK::stop ()
	{
		if ( this->ptrDevice() )
			this->ptrDevice()->stopReading();
		else
			std::cerr << "TobiiSDK::stop(): no device has been set" << std::endl << std::flush;
	}

	void TobiiSDK::receiveAcceleration ( AccelerationPtr ptrAcceleration )
	{
		this->ptrAcceleration() = ptrAcceleration;
	}

	void TobiiSDK::receiveOrientation ( OrientationPtr ptrOrientation )
	{
		this->ptrOrientation() = ptrOrientation;
	}

	void TobiiSDK::receiveSynkedData ( FramePtr ptrFrame, GazeFixationPtr ptrFixation ) 
	{
		this->mutex().lock();
		this->ptrFrame()    = ptrFrame;
		this->ptrFixation() = ptrFixation;
		this->mutex().unlock();
	}

	void TobiiSDK::readingFinished ()
	{
		this->hasFinished() = true;
	}
	// END CLASS SERVER
	// ##################################################

} // END NAMESPACE TOBII
// ##################################################

#endif // TOBII_SERVER_CPP
// ##################################################