// ##################################################
// ###        TOBII_INPUTVIDEOSTREAM_CPP          ###
// ##################################################
#ifndef TOBII_INPUTVIDEOSTREAM_CPP
#define TOBII_INPUTVIDEOSTREAM_CPP

// ##################################################
// ###                 DEPENDENCES                ###
// ##################################################

#include "VideoStream.hpp"

// ##################################################
// ###              NAMESPACE TOBII               ###
// ##################################################

namespace Tobii {

	// ##################################################
	// ###             CLASS VIDEO-STREAM             ###
	// ##################################################

	VideoStream::VideoStream ( const QString& filename )
	: Stream( filename )
	{}

	VideoStream::VideoStream ( const VideoStream& stream )
	: Stream( stream ), VideoHeader( stream )
	{}

	VideoStream& VideoStream::operator=( const VideoStream& stream )
	{
		this->Stream::operator=( stream );
		this->VideoHeader::operator=( stream );
		return (*this);
	}

	VideoStream::~VideoStream()
	{}

	// END CLASS VIDEO-STREAM
	// ##################################################

	// ##################################################
	// ###           CLASS I-VIDEO-STREAM             ###
	// ##################################################

	IVideoStream::IVideoStream ( const QString& filename )
	: VideoStream( filename )
	{}

	IVideoStream::IVideoStream ( const VideoStream& stream )
	: VideoStream( stream )
	{}

	IVideoStream::~IVideoStream()
	{}

	// END CLASS I-VIDEO-STREAM
	// ##################################################

	// ##################################################
	// ###           CLASS O-VIDEO-STREAM             ###
	// ##################################################

	OVideoStream::OVideoStream ( const QString& filename )
	: VideoStream( filename )
	{}

	OVideoStream::OVideoStream ( const VideoStream& stream )
	: VideoStream( stream )
	{}
	
	OVideoStream::~OVideoStream()
	{}

	// END CLASS O-VIDEO-STREAM
	// ##################################################

	// ##################################################
	// ###           CLASS O-VIDEO-STREAM             ###
	// ##################################################

	IOVideoStream::IOVideoStream ( const QString& filename )
	: VideoStream( filename )
	{}

	IOVideoStream::IOVideoStream ( const VideoStream& stream )
	: VideoStream( stream )
	{}
	
	IOVideoStream::~IOVideoStream()
	{}

	// END CLASS O-VIDEO-STREAM
	// ##################################################

} // END NAMESPACE TOBII
// ##################################################

#endif // TOBII_VIDEOSTREAM_CPP
// ##################################################