// ##################################################
// ###       TOBII_VIDEOFRAMESSTREAM_HPP          ###
// ##################################################
#ifndef TOBII_VIDEOFRAMESSTREAM_HPP
#define TOBII_VIDEOFRAMESSTREAM_HPP

// ##################################################
// ###                 DEPENDENCES                ###
// ##################################################

// INTERNAL MODULES:
#include "VideoStream.hpp"

// EXTERNAL MODULES:
#include <QDir>
#include <QString>

// ##################################################
// ###              NAMESPACE TOBII               ###
// ##################################################

/**
 * \namespace Tobii
 * 
 * Regroups all Tobii Glasses 2 SDK related types and algorithmes.
 **/
namespace Tobii {

	// ##################################################
	// ###         CLASS VIDEO-FRAMES-STREAM          ###
	// ##################################################

	class VideoFramesStream : public IOVideoStream
	{
		// --------------------------------------------------
		// MEMBER VARIABLES
	private:
		QString _fullpath;
		bool	_isOpen;

		// --------------------------------------------------
		// CONSTRUCTOR - DESTRUCTOR
	public:
		VideoFramesStream ( const QString& name = "", bool openEmpty = false );
		VideoFramesStream ( const VideoFramesStream& stream );

		VideoFramesStream& operator= ( const VideoFramesStream& stream );

		// --------------------------------------------------
		// GETTERS - SETTERS

		const QString&	fullpath () const;
		QString&		fullpath ();
		QString			getFileName ( Int64 timeStamp ) const;

		// --------------------------------------------------
		// OPEN - CLOSE

		virtual bool	move	( const QString& foldername );
		virtual bool	open	( const QString& foldername );
		virtual bool	open	( const QString& foldername, bool openEmpty );
		virtual bool	isOpen	() const;
		virtual bool&	isOpen	();
		virtual bool	close	();

		// --------------------------------------------------
		// READ

		virtual Frame getFrameAt		( Int64 timestamp );
		virtual Frame getCurrentFrame	();
		virtual Frame getNextFrame		();
		virtual Frame getPreviousFrame	();

		virtual VideoFramesStream& operator>> ( Frame& frame );

		// --------------------------------------------------
		// WRITE

		void setFrameAt		 ( Int64 timestamp, const Frame& frame );
		void setCurrentFrame ( const Frame& frame );
		void addFrame		 ( const Frame& frame );

		virtual VideoFramesStream& operator<< ( const Frame& frame );

	}; // END CLASS VIDEO-FRAMES-STREAM
	// ##################################################

	using VideoFramesStreamPtr = std::shared_ptr< VideoFramesStream >;

} // END NAMESPACE TOBII
// ##################################################

#endif // TOBII_VIDEOFRAMESSTREAM_HPP
// ##################################################