// ##################################################
// ###              TOBII_PROJECT_HPP             ###
// ##################################################
#ifndef TOBII_PROJECT_HPP
#define TOBII_PROJECT_HPP

// ##################################################
// ###                 DEPENDENCES                ###
// ##################################################

// INTERNAL MODULES
#include "TobiiSDK/Stream/VideoFramesStream.hpp"

// ##################################################
// ###              NAMESPACE TOBII               ###
// ##################################################

namespace Tobii {

	// ##################################################
	// ###             TYPES DEFINITION               ###
	// ##################################################

	using VideoStreamsMap = std::map< QString, IOVideoStreamPtr >;
	using FramesMap       = std::map< QString, Frame >;

	// ##################################################
	// ###               CLASS PROJECT                ###
	// ##################################################

	class Project
	{
		// --------------------------------------------------
		// STATIC MEMBER
	private:
		static IOVideoStreamPtr Null;

	public:
		static const QString Video, Saliency, SaliencyHeatMap, SaliencyWeightedMap, Annotation, AnnotationHeatMap, AnnotationWeightedMap;

		// --------------------------------------------------
		// MEMBER VARIABLES
	private:
		QString			_fullpath, _name;
		bool			_isOpen;
		VideoStreamsMap	_streams;
		QStringList		_streamNames;

		// --------------------------------------------------
		// CONSTRUCTOR - DESTRUCTOR
	public:
		Project ( const QString& folder = "", bool openEmpty = false, const QStringList& streamNames = QStringList() );
		Project ( const Project& project );
		virtual ~Project ();
		Project& operator= ( const Project& project );

		// --------------------------------------------------
		// GETTERS - SETTERS

		const QString&			name		() const;
		QString&				name		();
		const QString&			fullpath	() const;
		QString&				fullpath	();
		const VideoStreamsMap&	streams		() const;
		VideoStreamsMap&		streams		();
		const QStringList&		streamNames	() const;
		QStringList&			streamNames	();
		const IOVideoStreamPtr&	getStream	( const QString& name ) const;
		IOVideoStreamPtr&		getStream	( const QString& name );

		cv::Size	resolution			() const;
		int			fps					() const;
		int			frameCount			() const;
		double		format				() const;
		Int64		duration			() const;
		Int64		currentTimeStamp	() const;
		Int64		currentIndex		() const;
		Int64		firstIndex			() const;
		Int64		firstTimeStamp		() const;
		Int64		lastIndex			() const;
		Int64		lastTimeStamp		() const;

		void next ();
		void previous ();

		void setCurrentIndex	 ( Int64 index );
		void setCurrentTimeStamp ( Int64 timestamp );

		// --------------------------------------------------
		// OPEN - CLOSE

		void	move	( const QString& folder );
		void	open	( const QString& folder, bool openEmpty = false, const QStringList& streamNames = QStringList() );
		bool	isOpen	() const;
		bool&	isOpen	();
		void	close	();

		// --------------------------------------------------
		// READ

		FramesMap	getNextFrames		();
		FramesMap	getPreviousFrames	();
		FramesMap	getCurrentFrames	();
		FramesMap	getFramesAt			( Int64 timestamp );
		Frame		getFrameOf			( const QString& name, Int64 timeStamp = -1 ) const;

		// --------------------------------------------------
		// WRITE

		void setFramesAt		( Int64 timestamp, const FramesMap& frames );
		void setFrameOf			( const QString& name, const Frame& frame, Int64 timeStamp = -1 );
		void setCurrentFrames	( const FramesMap& frames );

		// --------------------------------------------------
		// ADD
		
		void addFrames	( const FramesMap& frames );

	}; // END CLASS PROJECT
	// ##################################################

	using ProjectPtr = std::shared_ptr< Project >;
	
} // END NAMESPACE TOBII
// ##################################################

#endif // TOBII_PROJECT_HPP
// ##################################################