// ##################################################
// ###        TOBII_OUTPUTVIDEOSTREAM_HPP         ###
// ##################################################
#ifndef TOBII_OUTPUTVIDEOSTREAM_HPP
#define TOBII_OUTPUTVIDEOSTREAM_HPP

// ##################################################
// ###                 DEPENDENCES                ###
// ##################################################

// STANDARD LIBRARIES: 
#include <iostream>
#include <vector>

// INTERNAL MODULES:
#include "VideoStream.hpp"

// EXTERNAL LIBRARIES: 
#include <opencv2/highgui/highgui.hpp>

// ##################################################
// ###              NAMESPACE TOBII               ###
// ##################################################

/**
 * \namespace Tobii
 * 
 * Regroups all Tobii Glasses 2 SDK related types and algorithmes.
 **/
namespace Tobii {

	// ##################################################
	// ###        CLASS OUTPUT-VIDEO-STREAM           ###
	// ##################################################

	class OutputVideoStream : public virtual VideoStream, public cv::VideoWriter
	{
	public:
		OutputVideoStream ( const QString& filename = "", cv::Size size = cv::Size(720, 405), double fps = 0 );
		OutputVideoStream ( const OutputVideoStream& stream );

		virtual bool open ( const QString& filename );
		virtual bool open ( const QString& filename, cv::Size size, double fps );
		virtual bool isOpen () const;
		virtual bool close ();

		OutputVideoStream& operator=( const OutputVideoStream& stream );

	}; // END CLASS INPUT-VIDEO-STREAM
	// ##################################################

} // END NAMESPACE TOBII
// ##################################################

#endif // TOBII_OUTPUTVIDEOSTREAM_HPP
// ##################################################