// ##################################################
// ###        TOBII_INPUTVIDEOSTREAM_HPP          ###
// ##################################################
#ifndef TOBII_INPUTVIDEOSTREAM_HPP
#define TOBII_INPUTVIDEOSTREAM_HPP

// ##################################################
// ###                 DEPENDENCES                ###
// ##################################################

// STANDARD LIBRARIES: 
#include <iostream>
#include <vector>

// INTERNAL MODULES:
#include "VideoStream.hpp"

// EXTERNAL LIBRARIES: 
#include <opencv2/highgui/highgui.hpp>

// ##################################################
// ###              NAMESPACE TOBII               ###
// ##################################################

/**
 * \namespace Tobii
 * 
 * Regroups all Tobii Glasses 2 SDK related types and algorithmes.
 **/
namespace Tobii {

	// ##################################################
	// ###         CLASS INPUT-VIDEO-STREAM           ###
	// ##################################################

	class InputVideoStream : public virtual VideoStream, private cv::VideoCapture
	{
	public:
		InputVideoStream ( const QString& name = "" );
		InputVideoStream ( const InputVideoStream& stream );
		~InputVideoStream ();

		virtual bool open ( const QString& name );
		virtual bool isOpen () const;
		virtual bool close ();

		virtual Frame getNextFrame ();

		InputVideoStream& operator>>( Frame& frame );

		InputVideoStream& operator=( const InputVideoStream& stream );

	}; // END CLASS INPUT-VIDEO-STREAM
	// ##################################################

} // END NAMESPACE TOBII
// ##################################################

#endif // TOBII_INPUTVIDEOSTREAM_HPP
// ##################################################