// ##################################################
// ###        TOBII_INPUTVIDEOSTREAM_CPP          ###
// ##################################################
#ifndef TOBII_INPUTVIDEOSTREAM_CPP
#define TOBII_INPUTVIDEOSTREAM_CPP

// ##################################################
// ###                 DEPENDENCES                ###
// ##################################################

#include "InputVideoStream.hpp"

// ##################################################
// ###              NAMESPACE TOBII               ###
// ##################################################

namespace Tobii {

	// ##################################################
	// ###          CLASS INPUT-VIDEO-STREAM          ###
	// ##################################################

	InputVideoStream::InputVideoStream ( const QString& name )
	: VideoStream( name )
	{
		if ( ! name.isEmpty() )
			this->open( name );
	}

	InputVideoStream::InputVideoStream ( const InputVideoStream& stream )
	: VideoStream( stream ), cv::VideoCapture( stream )
	{}

	InputVideoStream::~InputVideoStream ()
	{
		this->close();
	}

	bool InputVideoStream::open ( const QString& name )
	{
		if ( ! name.isEmpty() )
		{
			this->cv::VideoCapture::open( name.toStdString() );

			if ( this->isOpen() )
			{
				// Read the stream properties from OpenCV VideoCapture
				this->resolution().width  = this->get( CV_CAP_PROP_FRAME_WIDTH	);
				this->resolution().height = this->get( CV_CAP_PROP_FRAME_HEIGHT	); 
				this->fps()				  = this->get( CV_CAP_PROP_FPS			);
				this->frameCount()		  = this->get( CV_CAP_PROP_FRAME_COUNT	);
				this->format()			  = this->get( CV_CAP_PROP_FORMAT		);
				this->currentTimeStamp()  = this->get( CV_CAP_PROP_POS_MSEC		);
				return true;
			}
			else
				std::cerr << "InputVideoStream::open(\""<< name.toStdString() << "\"), failed to open file." <<std::endl<<std::flush;
		}
		return false;
	}

	bool InputVideoStream::isOpen () const
	{
		return this->cv::VideoCapture::isOpened();
	}

	bool InputVideoStream::close ()
	{
		if ( this->isOpen() )
			this->cv::VideoCapture::release();
		return this->isOpen();
	}

	Frame InputVideoStream::getNextFrame ()
	{
		Frame frame;

		// Time stamp
		frame.timeStamp() = this->currentTimeStamp();

		// Load the new image
		static_cast< cv::VideoCapture& >( *this ) >> frame;

		// Check status
		if ( frame.cols > 0 && frame.rows > 0 )
			frame.status() = 0;
		else
			frame.status() = 1;

		// Update the time stamp
		this->currentTimeStamp() = this->get( CV_CAP_PROP_POS_MSEC );

		return frame;
	}

	InputVideoStream& InputVideoStream::operator>>( Frame& frame )
	{
		frame = this->getNextFrame();
		return (*this);
	}

	InputVideoStream& InputVideoStream::operator=( const InputVideoStream& stream )
	{
		this->VideoStream::operator=( stream );
		this->cv::VideoCapture::operator=( stream );
		return (*this);
	}

	// END CLASS INPUT-VIDEO-STREAM
	// ##################################################

} // END NAMESPACE TOBII
// ##################################################

#endif // TOBII_VIDEOSTREAM_HPP
// ##################################################