// ##################################################
// ###             TOBII_RECORDER_HPP             ###
// ##################################################
#ifndef TOBII_RECORDER_HPP
#define TOBII_RECORDER_HPP

// ##################################################
// ###                 DEPENDENCES                ###
// ##################################################

// INTERNAL MODULES
#include "Synchronizer.hpp"
#include "GazeRecordings.hpp"
#include "AccelerationRecordings.hpp"
#include "OrientationRecordings.hpp"
#include "FrameRecordings.hpp"
#include "Interpolation.hpp"

// EXTERNAL LIBRARIES
#include <QObject>

// ##################################################
// ###              NAMESPACE TOBII               ###
// ##################################################
namespace Tobii {

	// ##################################################
	// ###                CLASS RECORDER              ###
	// ##################################################
	
	class Recorder : public Synchronizer
	{
		Q_OBJECT
	private:
		bool				 	_keepAllData;
		bool					_forceInterpolation;
		bool					_forceComputingDistance;
		Int64					_windowSize;
		GazeRecordings			_gazeRecordings;
		AccelerationRecordings	_accelerationRecordings;
		OrientationRecordings	_orientationRecordings;
		FrameRecordings			_frameRecordings;

	public:
		Recorder ( Int64 windowSize = 2000, bool keepAllData = false, bool forceInterpolation = true, bool forceComputingDistance = false, QObject* parent = NULL );
		virtual ~Recorder ();

		bool							keepAllData				() const;
		bool&							keepAllData				();
		bool							liveInterpolation		() const;
		bool&							liveInterpolation		();
		bool							forceInterpolation		() const;
		bool&							forceInterpolation		();
		bool							forceComputingDistance	() const;
		bool&							forceComputingDistance	();
		Int64							windowSize				() const;
		Int64&							windowSize				();
		Int64							gazeBufferSize			() const;
		Int64&							gazeBufferSize			();
		Int64							frameBufferSize			() const;
		Int64&							frameBufferSize			();
		Int64							accelerationBufferSize	() const;
		Int64&							accelerationBufferSize	();
		Int64							orientationBufferSize	() const;
		Int64&							orientationBufferSize	();

		const GazeRecordings&			gazeRecordings			() const;
		GazeRecordings&					gazeRecordings			();
		const AccelerationRecordings&	accelerationRecordings	() const;
		AccelerationRecordings&			accelerationRecordings	();
		const OrientationRecordings&	orientationRecordings	() const;
		OrientationRecordings&			orientationRecordings	();
		const FrameRecordings&			frameRecordings			() const;
		FrameRecordings&				frameRecordings			();

	signals:
		void frameRecorded			( FramePtr			ptrFrame		);
		void gazeRecorded			( GazeFixationPtr	ptrFixation 	);
		void orientationRecorded	( OrientationPtr	ptrOrientation	);
		void accelerationRecorded	( AccelerationPtr	ptrAcceleration	);
		void frameInterpolated		( FramePtr ptrFrame, GazeFixationPtr ptrFixation );

	public slots:
		void setKeepAllData					( bool  value );
		void setForceInterpolation			( bool  value );
		void setForceComputingDistance		( bool  value );
		void setWindowSize					( Int64 value );
		void setGazeBufferMaxSize			( Int64 value );
		void setFrameBufferMaxSize			( Int64 value );
		void setAccelerationBufferMaxSize	( Int64 value );
		void setOrientationBufferMaxSize	( Int64 value );
		void recordData						( DataPacketPtr gazePacket );
		void recordFrame					( FramePtr      frame      );

	private:
		Recorder ( const Recorder& device ) = delete;
		Recorder& operator= ( const Recorder& device ) = delete;

	}; // END CLASS RECORDER
	// ##################################################

} // END NAMESPACE TOBII
// ##################################################

#endif // TOBII_RECORDER_HPP
// ##################################################