// ##################################################
// ###      TOBII_ORIENTATIONRECORDINGS_HPP       ###
// ##################################################
#ifndef TOBII_ORIENTATIONRECORDINGS_CPP
#define TOBII_ORIENTATIONRECORDINGS_CPP

// ##################################################
// ###                 DEPENDENCES                ###
// ##################################################

#include "OrientationRecordings.hpp"

// ##################################################
// ###              NAMESPACE TOBII               ###
// ##################################################
namespace Tobii {

	// ##################################################
	// ###         CLASS ORIENTATION-RECORDINGS       ###
	// ##################################################

	OrientationRecordings::OrientationRecordings ( Int64 bufferSize )
	: Super( bufferSize )
	{}

	OrientationRecordings::OrientationRecordings ( const OrientationRecordings& recordings )
	: Recordings( recordings )
	{}

	OrientationRecordings::~OrientationRecordings () {}

	OrientationRecordings& OrientationRecordings::insert ( const GyroscopePacket* ptrPacket )
	{
		if ( ptrPacket != NULL )
		{
			this->at( ptrPacket->timeStamp() ) = ptrPacket->orientation();
			
			// Update the status of the record (this does not filter out packets)
			if ( ptrPacket->status() != 0 )
				this->at( ptrPacket->timeStamp() ).status() = ptrPacket->status();
		}

		return (*this);
	}

	OrientationRecordings& OrientationRecordings::operator= ( const OrientationRecordings& recordings )
	{
		this->Recordings::operator=( recordings );
		return (*this);
	}

	// END CLASS ORIENTATION-RECORDINGS
	// ##################################################


} // END NAMESPACE TOBII
// ##################################################

#endif // TOBII_ORIENTATIONRECORDINGS_HPP
// ##################################################