// ##################################################
// ###         TOBII_GAZERECORDINGS_CPP           ###
// ##################################################
#ifndef TOBII_GAZERECORDINGS_CPP
#define TOBII_GAZERECORDINGS_CPP

// ##################################################
// ###                 DEPENDENCES                ###
// ##################################################

#include "GazeRecordings.hpp"

// ##################################################
// ###              NAMESPACE TOBII               ###
// ##################################################
namespace Tobii {

	// ##################################################
	// ###             CLASS GAZERECORDINGS           ###
	// ##################################################

	GazeRecordings::GazeRecordings ( Int64 bufferSize )
	: Super( bufferSize )
	{}

	GazeRecordings::GazeRecordings ( const GazeRecordings& recordings )
	: Super( recordings )
	{}

	GazeRecordings::~GazeRecordings () {}

	GazeRecordings& GazeRecordings::insert ( DataPacketPtr packet )
	{
		// Update the status of the record (this does not filter out packets)
		if ( packet->status() != 0 )
			this->at( packet->timeStamp() ).status() = packet->status();

		// The packet specifies the pupil center data field
		if ( packet->name() == "pc" )
			return this->insert(dynamic_cast< const PupilCenterPacket* >( packet.get() ));

		// The packet specifies the pupil diameter data field
		else if ( packet->name() == "pd" )
			return this->insert(dynamic_cast< const PupilDiameterPacket* >( packet.get() ));

		// The packet specifies the gaze direction field
		else if ( packet->name() == "gd" ) 
			return this->insert(dynamic_cast< const GazeDirectionPacket* >( packet.get() ));

		// The packet specifies the  2D gaze position data field
		else if ( packet->name() == "gp" ) 
			return this->insert(dynamic_cast< const Gaze2DPositionPacket* >( packet.get() ));

		// The packet specifies the  3D gaze position data field
		else if ( packet->name() == "gp3" )
			return this->insert(dynamic_cast< const Gaze3DPositionPacket* >( packet.get() ));

		return (*this);
	}

	GazeRecordings& GazeRecordings::insert ( const PupilCenterPacket* packet )
	{
		// Set the value in the correct eye
		if ( packet->eye() == EyeDataPacket::Eye::LEFT )
			this->at( packet->timeStamp() ).leftEye().setPupilCenter( *packet );
		else
			this->at( packet->timeStamp() ).rightEye().setPupilCenter( *packet );

		return (*this);
	}

	GazeRecordings& GazeRecordings::insert ( const PupilDiameterPacket* packet )
	{
		// Set the value in the correct eye
		if ( packet->eye() == EyeDataPacket::Eye::LEFT )
			this->at( packet->timeStamp() ).leftEye().setPupilDiameter( static_cast<float>(*packet) );
		else
			this->at( packet->timeStamp() ).rightEye().setPupilDiameter( static_cast<float>(*packet) );

		return (*this);
	}

	GazeRecordings& GazeRecordings::insert ( const GazeDirectionPacket* packet )
	{
		// Set the value in the correct eye
		if ( packet->eye() == EyeDataPacket::Eye::LEFT )
			this->at( packet->timeStamp() ).leftEye().setGazeDirection( *packet );
		else
			this->at( packet->timeStamp() ).rightEye().setGazeDirection( *packet );

		return (*this);
	}

	GazeRecordings& GazeRecordings::insert ( const Gaze2DPositionPacket* packet )
	{
		this->at( packet->timeStamp() ).setPosition2D( *packet );
		return (*this);
	}

	GazeRecordings& GazeRecordings::insert ( const Gaze3DPositionPacket* packet )
	{
		this->at( packet->timeStamp() ).setPosition3D( *packet );	
		return (*this);
	}

	GazeRecordings& GazeRecordings::operator= ( const GazeRecordings& recordings )
	{
		this->Super::operator=( recordings );
		return (*this);
	}

	// END CLASS GAZERECORDINGS
	// ##################################################

} // END NAMESPACE TOBII
// ##################################################

#endif // TOBII_GAZERECORDINGS_CPP
// ##################################################