// ##################################################
// ###            FRAMERECORDINGS_HPP             ###
// ##################################################
#ifndef FRAMERECORDINGS_HPP
#define FRAMERECORDINGS_HPP

// ##################################################
// ###                 DEPENDENCES                ###
// ##################################################

// INTERNAL MODULES
#include "TobiiSDK/Data/Recordings.hpp"
#include "TobiiSDK/Data/Frame.hpp"

// ##################################################
// ###              NAMESPACE TOBII               ###
// ##################################################
namespace Tobii {

	// ##################################################
	// ###                 CLASS FRAME                ###
	// ##################################################
	
	class FrameRecordings : public Recordings< Frame >
	{
	private:
		using Super = Recordings< Frame >;

	public:
		FrameRecordings ( Int64 bufferSize = 1 );
		FrameRecordings ( const FrameRecordings& recordings );
		virtual ~FrameRecordings ();

		using Iterator = Super::Iterator;
		using ConstIterator = Super::ConstIterator;

		using Super::at;
		using Super::insert;

		FrameRecordings& operator= ( const FrameRecordings& recordings );
	};

	using FrameRecordingsPtr = std::shared_ptr< FrameRecordings >;

	// END CLASS FRAME
	// ##################################################

} // END NAMESPACE TOBII
// ##################################################

#endif // FRAMERECORDINGS_HPP
// ##################################################