// ##################################################
// ###     TOBII_ACCELERATIONRECORDINGS_CPP       ###
// ##################################################
#ifndef TOBII_ACCELERATIONRECORDINGS_CPP
#define TOBII_ACCELERATIONRECORDINGS_CPP

// ##################################################
// ###                 DEPENDENCES                ###
// ##################################################

#include "AccelerationRecordings.hpp"

// ##################################################
// ###              NAMESPACE TOBII               ###
// ##################################################
namespace Tobii {

	// ##################################################
	// ###         CLASS ACCELERATION-RECORDINGS      ###
	// ##################################################

	AccelerationRecordings::AccelerationRecordings ( Int64 bufferSize )
	: Super( bufferSize )
	{}

	AccelerationRecordings::AccelerationRecordings ( const AccelerationRecordings& recordings )
	: Super( recordings )
	{}

	AccelerationRecordings::~AccelerationRecordings () {}

	AccelerationRecordings& AccelerationRecordings::insert ( const AccelerometerPacket* ptrPacket )
	{
		if ( ptrPacket != NULL )
		{
			this->at( ptrPacket->timeStamp() ) = ptrPacket->acceleration();
			
			// Update the status of the record (this does not filter out packets)
			if ( ptrPacket->status() != 0 )
				this->at( ptrPacket->timeStamp() ).status() = ptrPacket->status();
		}

		return (*this);
	}

	AccelerationRecordings& AccelerationRecordings::operator= ( const AccelerationRecordings& recordings )
	{
		this->Super::operator=( recordings );
		return (*this);
	}

	// END CLASS ACCELERATION-RECORDINGS
	// ##################################################

} // END NAMESPACE TOBII
// ##################################################

#endif // TOBII_ACCELERATIONRECORDINGS_CPP
// ##################################################