// ##################################################
// ###              TOBII_IMPORTER_HPP            ###
// ##################################################
#ifndef TOBII_IMPORTER_HPP
#define TOBII_IMPORTER_HPP

// ##################################################
// ###                 DEPENDENCES                ###
// ##################################################

// EXTERNAL LIBRARIES
#include <QDebug>
#include <QDialog>
#include <QDir>
#include <QObject>
#include <QFileDialog>
#include <QMessageBox>


// INTERNAL MODULES
#include "TobiiSDK/TobiiSDK.hpp"
#include "TobiiSDK/Device/FileDevice/FileDevice.hpp"
#include "TobiiSDK/Stream/Project.hpp"
#include "ImportationOptions.hpp"
#include "Saliency.hpp"

// ##################################################
// ###              NAMESPACE TOBII               ###
// ##################################################

namespace Tobii {

	// ##################################################
	// ###         CLASS INTEPORTATION-WIZARD         ###
	// ##################################################

	class Importer : public TobiiSDK
	{
	    Q_OBJECT
		
	private:
		ImportationOptions	_options;
		ProjectPtr			_ptrProject;

		const ImportationOptions&	options		() const;
		ImportationOptions&			options		();
		const ProjectPtr&			ptrProject	() const;
		ProjectPtr&					ptrProject	();

	public:
		Importer ( ProjectPtr ptrProject );
		
		void run ( const QString& dstFolder );

	public slots:
		void setOptions ( const ImportationOptions& options );

	private slots:
		virtual void receiveSynkedData ( FramePtr ptrFrame, GazeFixationPtr ptrFixation );

	signals:
		void update ();

	}; // END CLASS IMPORTER
	// ##################################################

} // END NAMESPACE TOBII
// ##################################################

#endif // TOBII_IMPORTER_HPP
// ##################################################