// ##################################################
// ###              TOBII_IMPORTER_CPP            ###
// ##################################################
#ifndef TOBII_IMPORTER_CPP
#define TOBII_IMPORTER_CPP

// ##################################################
// ###                 DEPENDENCES                ###
// ##################################################

#include "Importer.hpp"

// ##################################################
// ###              NAMESPACE TOBII               ###
// ##################################################

namespace Tobii {

	// ##################################################
	// ###         CLASS INTEPORTATION-WIZARD         ###
	// ##################################################
	
	const ImportationOptions&	Importer::options		() const	{ return this->_options;	}
	ImportationOptions&			Importer::options		()			{ return this->_options;	}
	const ProjectPtr&			Importer::ptrProject	() const	{ return this->_ptrProject;	}
	ProjectPtr&					Importer::ptrProject	()			{ return this->_ptrProject;	}

	Importer::Importer( ProjectPtr ptrProject )
	: _ptrProject( ptrProject )
	{}

	void Importer::run ( const QString& dstFolder )
	{
		// Create the file device
		this->setPtrDevice( std::make_shared< FileDevice >(this->options().resolution) );

		// Set SDK options:
		this->setKeepAllData			( this->options().keepAllRecordings		);
		this->setForceInterpolation		( this->options().forceInterpolation	);
		this->setForceComputingDistance	( this->options().recomputeDistance		);
		this->setWindowSize				( 2000 );

		// open the project, with every channels
		QString name = dstFolder+"/"+this->options().name;
		QStringList streamNames;
		streamNames
			<< Project::Video
			<< Project::Annotation;

		if ( this->options().computeSaliencyMaps )
			streamNames << Project::Saliency;

		// DISABLED: TO HEAVY ON DRIVE, BETTER TO DO IT LIVE
		// if ( this->options().computeHeatFrames )
		// DISABLED: TO HEAVY ON DRIVE, BETTER TO DO IT LIVE
		// if ( this->options().computeWeightedFrames )

		// open the project folder and streams
		this->ptrProject()->open(name, true, streamNames);
		
		// Read all
		this->startReading( this->options().gazeFileName, this->options().videoFileName );
		this->finishReading();
	}

	void Importer::setOptions ( const ImportationOptions& options )
	{
		this->options() = options;
	}

	void Importer::receiveSynkedData ( FramePtr ptrFrame, GazeFixationPtr ptrFixation )
	{
		// Lock the reading thread
		this->mutex().lock();

		// Create the list of frames
		FramesMap frames;
		frames.emplace( Project::Video, *ptrFrame );

		// Commpute and add optionals ones
		if ( this->options().computeSaliencyMaps )
		{
			Frame saliency = Saliency::computeSaliencyMap( *ptrFixation, this->options().resolution );
			frames.emplace( Project::Saliency, saliency );

			// DISABLED: TO HEAVY ON DRIVE, BETTER TO DO IT LIVE
			// if ( this->options().computeHeatFrames )
			// 	frames.emplace( Importer::HeatMap, Saliency::computeHeatMap(*ptrFrame, saliency) );
			// DISABLED: TO HEAVY ON DRIVE, BETTER TO DO IT LIVE
			// if ( this->options().computeWeightedFrames )
			// 	frames.emplace( Importer::WeightedMap, Saliency::computeWeightedMap(*ptrFrame, saliency) );
		}

		// Add them to the project
		this->ptrProject()->addFrames( frames );

		// unlock the reading thread
		this->mutex().unlock();
	}

	// END CLASS IMPORTER
	// ##################################################

} // END NAMESPACE TOBII
// ##################################################

#endif // TOBII_IMPORTER_CPP
// ##################################################