// ##################################################
// ###         TOBII_IMPORTATIONOPTIONS_HPP       ###
// ##################################################
#ifndef TOBII_IMPORTATIONOPTIONS_HPP
#define TOBII_IMPORTATIONOPTIONS_HPP

// ##################################################
// ###                 DEPENDENCES                ###
// ##################################################

// EXTERNAL LIBRARIES
#include <QString>
#include <opencv2/core/core.hpp>

// ##################################################
// ###              NAMESPACE TOBII               ###
// ##################################################

namespace Tobii {

	// ##################################################
	// ###       STRUCT IMPORTATION-OPTIONS           ###
	// ##################################################
	
	struct ImportationOptions
	{
		// General
		QString name;

		// Video file
		QString	videoFileName;
		cv::Size resolution;

		// Gaze Data
		QString gazeFileName;
		bool importAccelerometerRecords;
		bool importGyroscopeRecords;
		bool keepAllRecordings;
		bool forceInterpolation;
		bool recomputeDistance;

		// Other Options
		bool computeSaliencyMaps;
		bool computeHeatFrames;
		bool computeWeightedFrames;
	
	}; // END STRUCT IMPORTATION-OPTIONS
	// ##################################################

} // END NAMESPACE TOBII
// ##################################################

#endif // TOBII_IMPORTATIONOPTIONS_HPP
// ##################################################