// ##################################################
// ###          TOBII_FILEAPPLICATION_HPP         ###
// ##################################################
#ifndef TOBII_FILEAPPLICATION_HPP
#define TOBII_FILEAPPLICATION_HPP

// ##################################################
// ###                 DEPENDENCES                ###
// ##################################################

// INTERNAL MODULES
#include "Application.hpp"
#include "TobiiSDK/Device/FileDevice/FileDevice.hpp"

// ##################################################
// ###              NAMESPACE TOBII               ###
// ##################################################
namespace Tobii {

	// ##################################################
	// ###           CLASS FILE-APPLICATION           ###
	// ##################################################
	
	class FileApplication : public Application
	{
		Q_OBJECT
	private:
		QString _gazeFile, _videoFile;

	public:
		FileApplication ( const int argc, const char* argv[] );
		virtual ~FileApplication ();

		const QString&	gazeFile	() const;
		QString&		gazeFile	();
		const QString&	videoFile	() const;
		QString&		videoFile	();

		virtual void	parseOptions	( int argc, const char* argv[], int minNbArgs = 2 );
		virtual QString	usage			() const;
		virtual int		run				();
		
	private:
		FileApplication ( const FileApplication& ) = delete;
		FileApplication& operator= ( const FileApplication& ) = delete;

	}; // END CLASS FILE-APPLICATION
	// ##################################################

} // END NAMESPACE TOBII
// ##################################################

#endif // TOBII_FILEAPPLICATION_HPP
// ##################################################