// ##################################################
// ###          TOBII_FILEAPPLICATION_CPP         ###
// ##################################################
#ifndef TOBII_FILEAPPLICATION_CPP
#define TOBII_FILEAPPLICATION_CPP

// ##################################################
// ###                 DEPENDENCES                ###
// ##################################################

#include "FileApplication.hpp"

// ##################################################
// ###              NAMESPACE TOBII               ###
// ##################################################
namespace Tobii {

	// ##################################################
	// ###           CLASS LIVE-APPLICATION           ###
	// ##################################################

	FileApplication::FileApplication ( const int argc, const char* argv[] )
	: Application( argc, argv )
	{
		this->setPtrDevice( std::make_shared< FileDevice >(cv::Size(960, 540)) );
	}

	FileApplication::~FileApplication () {}

	const QString&	FileApplication::gazeFile	() const	{ return this->_gazeFile;	}
	QString&		FileApplication::gazeFile	()			{ return this->_gazeFile;	}
	const QString&	FileApplication::videoFile	() const	{ return this->_videoFile;	}
	QString&		FileApplication::videoFile	()			{ return this->_videoFile;	}

	void FileApplication::parseOptions ( int argc, const char* argv[], int minNbArgs )
	{
		this->Application::parseOptions( argc, argv, minNbArgs );
		this->gazeFile()  = argv[1];
		this->videoFile() = argv[2];
	}

	QString	FileApplication::usage () const
	{
		return QString( "USAGE : %1 %2" ).arg( this->name() ).arg( "<gaze-file.json> <video-file.json> <optionals...>, use -help for more informations." );
	}

	int FileApplication::run ()
	{
		
		this->startReading( this->gazeFile(), this->videoFile() );
		return EXIT_SUCCESS;
	}
	
	// END CLASS LIVE-APPLICATION
	// ##################################################

} // END NAMESPACE TOBII
// ##################################################

#endif // TOBII_LIVEAPPLICATION_CPP
// ##################################################