// ##################################################
// ###          VIDEOFILESTREAMER_HPP             ###
// ##################################################
#ifndef VIDEOFILESTREAMER_HPP
#define VIDEOFILESTREAMER_HPP

// ##################################################
// ###                 DEPENDENCES                ###
// ##################################################

// STANDARD LIBRARIES
#include <iostream>

// INTERNAL MODULES
#include "TobiiSDK/Stream/InputVideoStream.hpp"

// EXTERNAL LIBRARIES
#include <QString>
#include <QObject>
#include <QThread>
#include <opencv2/highgui/highgui.hpp>

// ##################################################
// ###              NAMESPACE TOBII               ###
// ##################################################
namespace Tobii {

	// ##################################################
	// ###           CLASS VIDEOFILESTREAMER          ###
	// ##################################################

	class VideoFileStreamer : public QThread
	{
		Q_OBJECT
	private:
		InputVideoStream _videoStream;
		bool		 	 _continueReading;
		cv::Size		 _resolution;

	public:
		VideoFileStreamer ( const cv::Size& resolution = cv::Size(), QObject* parent = NULL );
		VideoFileStreamer ( UInt8 width, UInt8 height, QObject* parent = NULL );
		~VideoFileStreamer ();

		bool			hasFinished () const;
		const cv::Size&	resolution	() const;
		cv::Size&		resolution	();

	protected:
		void run () Q_DECL_OVERRIDE;

	private:
		const InputVideoStream&	videoStream 	() const;
		InputVideoStream&		videoStream 	();
		bool					continueReading	() const;
		bool&					continueReading	();

		VideoFileStreamer ( const VideoFileStreamer& ) = delete;
		VideoFileStreamer& operator= ( const VideoFileStreamer& fileReader ) = delete;

	public slots:
		void startReading	( const QString& fileName );
		void stopReading	();
		void finishReading	();

	signals:
		void frameAvailable ( FramePtr frame );
	};

	// END CLASS VIDEOFILESTREAMER
	// ##################################################

} // END NAMESPACE TOBII
// ##################################################

#endif // VIDEOFILESTREAMER_HPP
// ##################################################