// ##################################################
// ###           DATAFILESTREAMER_HPP             ###
// ##################################################
#ifndef DATAFILESTREAMER_HPP
#define DATAFILESTREAMER_HPP

// ##################################################
// ###                 DEPENDENCES                ###
// ##################################################

// STANDARD LIBRARIES
#include <fstream>
#include <iostream>

// EXTERNAL LIBRARIES
#include <QObject>
#include <QThread>

// ##################################################
// ###              NAMESPACE TOBII               ###
// ##################################################
namespace Tobii {

	// ##################################################
	// ###           CLASS GAZEFILESTREAMER           ###
	// ##################################################

	class DataFileStreamer : public QThread
	{
		Q_OBJECT
	private:
		std::ifstream _fileStream;
		bool		  _continueReading;

	public:
		DataFileStreamer ( QObject* parent = NULL );
		~DataFileStreamer ();

		bool hasFinished () const;

	protected:
		void run () Q_DECL_OVERRIDE;

	private:
		const std::ifstream&	fileStream 		() const;
		std::ifstream&			fileStream 		();
		bool					continueReading	() const;
		bool&					continueReading	();

		DataFileStreamer ( const DataFileStreamer& ) = delete;
		DataFileStreamer& operator= ( const DataFileStreamer& fileReader ) = delete;

	public slots:
		void startReading	( const QString& fileName );
		void stopReading	();
		void finishReading	();

	signals:
		void dataAvailable ( std::string packet );
	};

	// END CLASS DATAFILESTREAMER
	// ##################################################

} // END NAMESPACE TOBII
// ##################################################

#endif // DATAFILESTREAMER_HPP
// ##################################################