// ##################################################
// ###           DATAFILESTREAMER_CPP             ###
// ##################################################
#ifndef DATAFILESTREAMER_CPP
#define DATAFILESTREAMER_CPP

// ##################################################
// ###                 DEPENDENCES                ###
// ##################################################

#include "DataFileStreamer.hpp"

// ##################################################
// ###              NAMESPACE TOBII               ###
// ##################################################
namespace Tobii {

	// ##################################################
	// ###           CLASS DATAFILESTREAMER           ###
	// ##################################################

	DataFileStreamer::DataFileStreamer ( QObject* parent )
	: QThread( parent ), _continueReading( false )
	{}

	DataFileStreamer::~DataFileStreamer ()
	{
		this->stopReading();
	}

	bool DataFileStreamer::hasFinished () const
	{
		return (this->continueReading() == false);
	}

	void DataFileStreamer::run ()
	{
		while ( this->continueReading() )
		{
			std::string line;
			this->fileStream() >> line;

			if ( ! line.empty() )
				emit this->dataAvailable( line );

			if ( ! this->fileStream().good() )
			{
				this->continueReading() = false;
				return this->quit();
			}

			QThread::msleep(1);
		}
		return this->quit();
	}

	const std::ifstream&	DataFileStreamer::fileStream 		() const	{ return this->_fileStream;			}
	std::ifstream&			DataFileStreamer::fileStream 		()			{ return this->_fileStream;			}
	bool					DataFileStreamer::continueReading	() const	{ return this->_continueReading;	}
	bool&					DataFileStreamer::continueReading	()			{ return this->_continueReading;	}

	void DataFileStreamer::startReading ( const QString& fileName )
	{
		if ( fileName.isEmpty() == false )
		{
			// open the file in read mode
			this->fileStream().open( fileName.toStdString(), std::istream::in );

			if ( ! this->fileStream().is_open() )
			{
				std::cerr << "Could not open data file \"" << fileName.toStdString() << "\" !" << std::endl;
				return;
			}

			// tell the reader to read on its own
			this->continueReading() = true;

			// read until the file is over or we later tell it to stop
			this->start();
		}
	}

	void DataFileStreamer::stopReading ()
	{
		if ( this->continueReading() == true )
		{
			this->continueReading() = false;
			this->wait();
		}

		if ( this->fileStream().is_open() )
			this->fileStream().close();
	}

	void DataFileStreamer::finishReading ()
	{
		this->wait();
	}

	// END CLASS DATAFILESTREAMER
	// ##################################################

} // END NAMESPACE TOBII
// ##################################################

#endif // DATAFILESTREAMER_CPP
// ##################################################