// ##################################################
// ###              TOBII_DEVICE_HPP              ###
// ##################################################
#ifndef TOBII_DEVICE_HPP
#define TOBII_DEVICE_HPP

// ##################################################
// ###                 DEPENDENCES                ###
// ##################################################

// INTERNAL MODULES
#include "DataParser.hpp"
#include "TobiiSDK/Data/Frame.hpp"

// EXTERNAL LIBRARIES
#include <QObject>

// ##################################################
// ###              NAMESPACE TOBII               ###
// ##################################################
namespace Tobii {

	// ##################################################
	// ###                 CLASS DEVICE               ###
	// ##################################################
	
	class Device : public DataParser
	{
		Q_OBJECT
	public:
		Device ( QObject* parent = NULL );
		virtual ~Device ();

		virtual bool			hasFinished	() const = 0;
		virtual const cv::Size&	resolution	() const = 0;
		virtual cv::Size&		resolution	() = 0;

	signals:
		void frameAvailable	( FramePtr frame );
		void finished ();

	public slots:
		virtual void startReading	( const QString& arg1 = "", const QString& arg2 = "" );
		virtual void stopReading	();
		virtual void finishReading	();
		
	private:
		Device ( const Device& device ) = delete;
		Device& operator= ( const Device& device ) = delete;
	};

	using DevicePtr = std::shared_ptr< Device >;

	// END CLASS DEVICE
	// ##################################################

} // END NAMESPACE TOBII
// ##################################################

#endif // TOBII_DEVICE_HPP
// ##################################################