// ##################################################
// ###             TOBII_VECTOR3_HPP              ###
// ##################################################
#ifndef TOBII_VECTOR3_CPP
#define TOBII_VECTOR3_CPP

// ##################################################
// ###                 DEPENDENCES                ###
// ##################################################

#include "Vector3.hpp"

// ##################################################
// ###               NAMESPACE TOBII              ###
// ##################################################
namespace Tobii {

	// ##################################################
	// ###                CLASS VECTOR3               ###
	// ##################################################

	Vector3::Vector3 ( float dx, float dy, float dz )
	: _dx( dx ), _dy( dy ), _dz( dz )
	{}

	Vector3::Vector3 ( const Vector3& vector )
	: _dx( vector.dx() ), _dy( vector.dy() ), _dz( vector.dz() )
	{}

	Vector3 Vector3::zero ()
	{
		return Vector3();
	}

	float  Vector3::dx () const	{ return this->_dx;	}
	float& Vector3::dx ()		{ return this->_dx;	}
	float  Vector3::dy () const	{ return this->_dy;	}
	float& Vector3::dy ()		{ return this->_dy;	}
	float  Vector3::dz () const	{ return this->_dz;	}
	float& Vector3::dz ()		{ return this->_dz;	}

	Vector3::operator std::string () const
	{
		std::stringstream formatedOutput;
		formatedOutput << "[" << this->dx() << "," << this->dy() << "," << this->dz() << "]";
		return formatedOutput.str();
	}

	float Vector3::norm () const
	{
		return std::sqrt( this->dx()*this->dx() + this->dy()*this->dy() + this->dz()*this->dz() );
	}

	Vector3& Vector3::operator= ( const Vector3& vector )
	{
		this->dx() = vector.dx();
		this->dy() = vector.dy();
		this->dz() = vector.dz();
		return (*this);
	}

	// END CLASS VECTOR3
	// ##################################################

	std::ostream& operator<< ( std::ostream& ostream, const Vector3& vector )
	{
		return ostream << static_cast< std::string >( vector );
	}

} // END NAMESPACE TOBII
// ##################################################

#endif // TOBII_VECTOR3_CPP
// ##################################################