// ##################################################
// ###          TOBII_RECORDINGS_HXX              ###
// ##################################################
#ifndef TOBII_RECORDINGS_HXX
#define TOBII_RECORDINGS_HXX

#include <iostream>
#include <typeinfo>

// ##################################################
// ###              NAMESPACE TOBI                ###
// ##################################################
namespace Tobii {

	// ##################################################
	// ###               CLASS RECORDINGS             ###
	// ##################################################

	template< typename Type >
	Recordings< Type >::Recordings ( Int64 bufferSize )
	: _bufferSize( bufferSize )
	{}

	template< typename Type >
	Recordings< Type >::Recordings ( const Recordings& recordings )
	: Super( recordings )
	{}

	template< typename Type >
	Recordings< Type >::~Recordings () {}

	template< typename Type >
	Int64 Recordings< Type >::bufferSize () const
	{
		return this->_bufferSize;
	}
	
	template< typename Type >
	Int64& Recordings< Type >::bufferSize ()
	{
		return this->_bufferSize;
	}

	template< typename Type >
	const Type& Recordings< Type >::at ( Int64 timeStamp ) const
	{
		return this->Super::at( timeStamp );
	}

	template< typename Type >
	Type& Recordings< Type >::at ( Int64 timeStamp )
	{
		if ( this->size() == this->bufferSize() )
			this->erase( this->begin() );

		if ( this->find(timeStamp) == this->end() )
			this->Super::emplace( timeStamp, Type(timeStamp) );

		return this->Super::at( timeStamp );
	}

	template< typename Type >
	Recordings<Type>& Recordings< Type >::insert ( const Type& record )
	{
		this->at( record.timeStamp() ) = record;
		return (*this);
	}

	template< typename Type >
	void
	Recordings< Type >::setBufferSize ( Int64 size )
	{
		this->bufferSize() = size;

		// if ( this->size() > this->bufferSize() )
		// 	this->erase( this->begin() );
	}
	

	template< typename Type >
	Recordings<Type>& Recordings< Type >::operator= ( const Recordings& recordings )
	{
		this->bufferSize() = recordings.bufferSize();
		this->Super::operator=( recordings );
		return (*this);
	}

	// END CLASS RECORDINGS
	// ##################################################

} // END NAMESPACE TOBII
// ##################################################

#endif // TOBII_RECORDINGS_HXX
// ##################################################