// ##################################################
// ###              TOBII_FRAME_CPP               ###
// ##################################################
#ifndef TOBII_FRAME_CPP
#define TOBII_FRAME_CPP

// ##################################################
// ###                 DEPENDENCES                ###
// ##################################################

#include "Frame.hpp"

// ##################################################
// ###              NAMESPACE TOBII               ###
// ##################################################
namespace Tobii {

	// ##################################################
	// ###                  CLASS FRAME               ###
	// ##################################################

	Frame::Frame ( Int64 timeStamp, UInt8 status, const cv::Mat& frame )
	: cv::Mat( frame ), Record( timeStamp, status )
	{}

	Frame::Frame ( const Frame& frame )
	: cv::Mat( frame ), Record( frame )
	{}

	Frame::operator bool () const
	{
		return ( (this->cols > 0) && (this->rows > 0) );
	}

	Frame& Frame::operator= ( const Frame& frame )
	{
		this->cv::Mat::operator=( frame );
		this->Record::operator=( frame );
		return (*this);
	}

	Frame& Frame::operator= ( const cv::Mat& frame )
	{
		this->cv::Mat::operator=( frame );
		return (*this);
	}

	// END CLASS FRAME
	// ##################################################

} // END NAMESPACE TOBII
// ##################################################

#endif // TOBII_FRAME_CPP
// ##################################################