// ##################################################
// ###           TOBII_DATAPACKETS_CPP            ###
// ##################################################
#ifndef TOBII_DATAPACKETS_CPP
#define TOBII_DATAPACKETS_CPP

// ##################################################
// ###                 DEPENDENCES                ###
// ##################################################

#include "DataPackets.hpp"

// ##################################################
// ###              NAMESPACE TOBII               ###
// ##################################################
namespace Tobii {

	// ##################################################
	// ###             CLASS DATA-PACKET              ###
	// ##################################################

	DataPacket::DataPacket ( Int64 timeStamp, UInt8 status, const std::string& name )
	: Record( timeStamp, status ), _name( name )
	{}

	DataPacket::DataPacket ( const DataPacket& dataPacket )
	: Record( dataPacket ), _name( dataPacket.name() )
	{}

	DataPacket::~DataPacket () {}

	const std::string&	DataPacket::name () const	{ return this->_name;	}
	std::string&		DataPacket::name ()			{ return this->_name;	}

	DataPacket& DataPacket::operator= ( const DataPacket& dataPacket )
	{
		this->Record::operator=( dataPacket );
		this->name() = dataPacket.name();
		return (*this);
	}

	// END CLASS DATA-PACKET
	// ##################################################

	// ##################################################
	// ###           CLASS EYE-DATA-PACKET            ###
	// ##################################################

	EyeDataPacket::EyeDataPacket ( Int64 timeStamp, UInt8 status, const std::string& name, Eye eye )
	: DataPacket( timeStamp, status, name ), _eye( eye )
	{}

	EyeDataPacket::EyeDataPacket ( const EyeDataPacket& dataPacket )
	: DataPacket( dataPacket ), _eye( dataPacket.eye() )
	{}

	EyeDataPacket::Eye	EyeDataPacket::eye	() const	{ return this->_eye;	}
	EyeDataPacket::Eye&	EyeDataPacket::eye	()			{ return this->_eye;	}

	EyeDataPacket& EyeDataPacket::operator= ( const EyeDataPacket& gazePacket )
	{
		this->DataPacket::operator=( gazePacket );
		this->eye() = gazePacket.eye();
		return (*this);
	}

	// END CLASS EYE-DATA-PACKET
	// ##################################################

	// ##################################################
	// ###          CLASS PUPIL-CENTER-PACKET         ###
	// ##################################################

	PupilCenterPacket::PupilCenterPacket ( Int64 timeStamp, UInt8 status, const Point3& pupilCenter, Eye eye )
	: EyeDataPacket( timeStamp, status, "pc", eye ), Point3( pupilCenter )
	{}

	PupilCenterPacket::PupilCenterPacket ( const PupilCenterPacket& dataPacket )
	: EyeDataPacket( dataPacket ), Point3( dataPacket )
	{}

	const Point3&	PupilCenterPacket::pupilCenter	() const { return static_cast< const Point3& >( *this ); }
	Point3&			PupilCenterPacket::pupilCenter	() 		 { return static_cast<       Point3& >( *this ); }

	PupilCenterPacket::operator std::string () const
	{
		std::stringstream formatedOutput;
		
		formatedOutput
			<< "{\"ts\":"	<< this->timeStamp()
			<< ",\"s\":"	<< this->status()
			<< ",\"pc\":"	<< static_cast< const Point3& >( *this )
			<< ",\"eye\":"	<< (this->eye() == Eye::LEFT ? "\"left\"" : "\"right\"")
			<< "}";

		return formatedOutput.str();
	}

	PupilCenterPacket& PupilCenterPacket::operator= ( const Point3& center )
	{
		this->Point3::operator=( center );
		return (*this);
	}

	PupilCenterPacket& PupilCenterPacket::operator= ( const PupilCenterPacket& dataPacket )
	{
		this->EyeDataPacket::operator=( dataPacket );
		this->Point3::operator=( dataPacket );
		return (*this);
	}

	// END CLASS PUPIL-CENTER-PACKET
	// ##################################################

	// ##################################################
	// ###         CLASS PUPIL-DIAMETER-PACKET        ###
	// ##################################################

	PupilDiameterPacket::PupilDiameterPacket ( Int64 timeStamp, UInt8 status, float pupilDiameter, Eye eye )
	: EyeDataPacket( timeStamp, status, "pd", eye ), _pupilDiameter( pupilDiameter )
	{}

	PupilDiameterPacket::PupilDiameterPacket ( const PupilDiameterPacket& dataPacket )
	: EyeDataPacket( dataPacket ), _pupilDiameter( dataPacket.pupilDiameter() )
	{}

	float	PupilDiameterPacket::pupilDiameter	() const { return this->_pupilDiameter;	}
	float&	PupilDiameterPacket::pupilDiameter	()		 { return this->_pupilDiameter;	}
	
	PupilDiameterPacket::operator float () const
	{
		return this->pupilDiameter();
	}

	PupilDiameterPacket::operator std::string () const
	{
		std::stringstream formatedOutput;
		
		formatedOutput
			<< "{\"ts\":"	<< this->timeStamp()
			<< ",\"s\":"	<< this->status()
			<< ",\"pd\":"	<< this->pupilDiameter()
			<< ",\"eye\":"	<< (this->eye() == Eye::LEFT ? "\"left\"" : "\"right\"")
			<< "}";

		return formatedOutput.str();
	}

	PupilDiameterPacket& PupilDiameterPacket::operator= ( float pupilDiameter )
	{
		this->pupilDiameter() = pupilDiameter;
		return (*this);
	}

	PupilDiameterPacket& PupilDiameterPacket::operator= ( const PupilDiameterPacket& dataPacket )
	{
		this->EyeDataPacket::operator=( dataPacket );
		this->pupilDiameter() = dataPacket.pupilDiameter();
		return (*this);
	}

	// END CLASS PUPIL-DIAMETER-PACKET
	// ##################################################

	// ##################################################
	// ###         CLASS GAZE-DIRECTION-PACKET        ###
	// ##################################################

	GazeDirectionPacket::GazeDirectionPacket ( Int64 timeStamp, UInt8 status, const Vector3& gazeDirection, Eye eye )
	: EyeDataPacket( timeStamp, status, "gd", eye ), Vector3( gazeDirection )
	{}

	GazeDirectionPacket::GazeDirectionPacket ( const GazeDirectionPacket& dataPacket )
	: EyeDataPacket( dataPacket ), Vector3( dataPacket )
	{}

	const Vector3&	GazeDirectionPacket::gazeDirection	() const { return static_cast< const Vector3& >( *this );	}
	Vector3&		GazeDirectionPacket::gazeDirection	()		 { return static_cast<       Vector3& >( *this );	}

	GazeDirectionPacket::operator std::string () const
	{
		std::stringstream formatedOutput;
		
		formatedOutput
			<< "{\"ts\":"	<< this->timeStamp()
			<< ",\"s\":"	<< this->status()
			<< ",\"gd\":"	<< static_cast< const Vector3& >( *this )
			<< ",\"eye\":"	<< (this->eye() == Eye::LEFT ? "\"left\"" : "\"right\"")
			<< "}";

		return formatedOutput.str();
	}

	GazeDirectionPacket& GazeDirectionPacket::operator= ( const Vector3& gazeDirection )
	{
		this->Vector3::operator=( gazeDirection );
		return (*this);
	}

	GazeDirectionPacket& GazeDirectionPacket::operator= ( const GazeDirectionPacket& dataPacket )
	{
		this->EyeDataPacket::operator=( dataPacket );
		this->Vector3::operator=( dataPacket );
		return (*this);
	}

	// END CLASS GAZE-DIRECTION-PACKET
	// ##################################################

	// ##################################################
	// ###       CLASS GAZE-2D-POSITION-PACKET        ###
	// ##################################################

	Gaze2DPositionPacket::Gaze2DPositionPacket ( Int64 timeStamp, UInt8 status, const Point2& gazePosition )
	: DataPacket( timeStamp, status, "gp" ), Point2( gazePosition )
	{}

	Gaze2DPositionPacket::Gaze2DPositionPacket ( const Gaze2DPositionPacket& dataPacket )
	: DataPacket( dataPacket ), Point2( dataPacket )
	{}

	const Point2&	Gaze2DPositionPacket::gazePosition	() const	{ return static_cast< const Point2& >( *this );	}
	Point2&			Gaze2DPositionPacket::gazePosition	()			{ return static_cast<       Point2& >( *this );	}

	Gaze2DPositionPacket::operator std::string () const
	{
		std::stringstream formatedOutput;
		
		formatedOutput
			<< "{\"ts\":"	<< this->timeStamp()
			<< ",\"s\":"	<< this->status()
			<< ",\"gp\":"	<< static_cast< std::string >( this->gazePosition() )
			<< "}";

		return formatedOutput.str();
	}

	Gaze2DPositionPacket& Gaze2DPositionPacket::operator= ( const Point2& gazePosition )
	{
		this->Point2::operator=( gazePosition );
		return (*this);
	}

	Gaze2DPositionPacket& Gaze2DPositionPacket::operator= ( const Gaze2DPositionPacket& dataPacket )
	{
		this->DataPacket::operator=( dataPacket );
		this->gazePosition() = dataPacket.gazePosition();
		return (*this);
	}

	// END CLASS GAZE-2D-POSITION-PACKET
	// ##################################################

	// ##################################################
	// ###       CLASS GAZE-3D-POSITION-PACKET        ###
	// ##################################################

	Gaze3DPositionPacket::Gaze3DPositionPacket ( Int64 timeStamp, UInt8 status, const Point3& gazePosition )
	: DataPacket( timeStamp, status, "gp3" ), Point3( gazePosition )
	{}

	Gaze3DPositionPacket::Gaze3DPositionPacket ( const Gaze3DPositionPacket& dataPacket )
	: DataPacket( dataPacket ), Point3( dataPacket )
	{}

	const Point3&	Gaze3DPositionPacket::gazePosition	() const	{ return static_cast< const Point3& >( *this );	}
	Point3&			Gaze3DPositionPacket::gazePosition	()			{ return static_cast<       Point3& >( *this );	}

	Gaze3DPositionPacket::operator std::string () const
	{
		std::stringstream formatedOutput;
		
		formatedOutput
			<< "{\"ts\":"	<< this->timeStamp()
			<< ",\"s\":"	<< this->status()
			<< ",\"gp3\":"	<< static_cast< std::string >( this->gazePosition() )
		<< "}";

		return formatedOutput.str();
	}

	Gaze3DPositionPacket& Gaze3DPositionPacket::operator= ( const Point3& gazePosition )
	{
		this->Point3::operator=( gazePosition );
		return (*this);
	}

	Gaze3DPositionPacket& Gaze3DPositionPacket::operator= ( const Gaze3DPositionPacket& dataPacket )
	{
		this->DataPacket::operator=( dataPacket );
		this->gazePosition() = dataPacket.gazePosition();
		return (*this);
	}

	// END CLASS GAZE-3D-POSITION-PACKET
	// ##################################################

	// ##################################################
	// ###          CLASS GYROSCOPE-PACKET           ###
	// ##################################################

	GyroscopePacket::GyroscopePacket ( Int64 timeStamp, UInt8 status, const Vector3& orientation )
	: DataPacket( timeStamp, status, "gy" ), Vector3( orientation )
	{}

	GyroscopePacket::GyroscopePacket ( const GyroscopePacket& dataPacket )
	: DataPacket( dataPacket ), Vector3( dataPacket )
	{}

	const Vector3&	GyroscopePacket::orientation () const { return static_cast< const Vector3& >( *this );	}
	Vector3&		GyroscopePacket::orientation ()		  { return static_cast<       Vector3& >( *this );	}

	GyroscopePacket::operator std::string () const
	{
		std::stringstream formatedOutput;
		
		formatedOutput
			<< "{\"ts\":"	<< this->timeStamp()
			<< ",\"s\":"	<< this->status()
			<< ",\"gy\":"	<< static_cast< std::string >( this->orientation() )
		<< "}";

		return formatedOutput.str();
	}

	GyroscopePacket& GyroscopePacket::operator= ( const Vector3& orientation )
	{
		this->Vector3::operator=( orientation );
		return (*this);
	}

	GyroscopePacket& GyroscopePacket::operator= ( const GyroscopePacket& dataPacket )
	{
		this->DataPacket::operator=( dataPacket );
		this->orientation() = dataPacket.orientation();
		return (*this);
	}

	// END CLASS GYROSCOPE-PACKET
	// ##################################################

	// ##################################################
	// ###        CLASS ACCELEROMETER-PACKET          ###
	// ##################################################

	AccelerometerPacket::AccelerometerPacket ( Int64 timeStamp, UInt8 status, const Vector3& acceleration )
	: DataPacket( timeStamp, status, "ac" ), Vector3( acceleration )
	{}

	AccelerometerPacket::AccelerometerPacket ( const AccelerometerPacket& dataPacket )
	: DataPacket( dataPacket ), Vector3( dataPacket )
	{}

	const Vector3&	AccelerometerPacket::acceleration	() const	{ return static_cast< const Vector3& >( *this );	}
	Vector3&		AccelerometerPacket::acceleration	()			{ return static_cast<       Vector3& >( *this );	}

	AccelerometerPacket::operator std::string () const
	{
		std::stringstream formatedOutput;
		
		formatedOutput
			<< "{\"ts\":" << this->timeStamp()
			<< ",\"s\":" << this->status()
			<< ",\"ac\":" << static_cast< std::string >( this->acceleration() )
		<< "}";

		return formatedOutput.str();
	}

	AccelerometerPacket& AccelerometerPacket::operator= ( const Vector3& acceleration )
	{
		this->Vector3::operator=( acceleration );
		return (*this);
	}

	AccelerometerPacket& AccelerometerPacket::operator= ( const AccelerometerPacket& dataPacket )
	{
		this->DataPacket::operator=( dataPacket );
		this->acceleration() = dataPacket.acceleration();
		return (*this);
	}

	// END CLASS ACCELEROMETER-PACKET
	// ##################################################

	// ##################################################
	// ###          CLASS PTS-SYNC-PACKET             ###
	// ##################################################

	PTSSyncPacket::PTSSyncPacket ( Int64 timeStamp, UInt8 status, Int64 pipelineTimeStamp, UInt8 pipelineVersion )
	: DataPacket( timeStamp, status, "pts" ), _pipelineTimeStamp( pipelineTimeStamp ), _pipelineVersion( pipelineVersion )
	{}

	PTSSyncPacket::PTSSyncPacket ( const PTSSyncPacket& dataPacket )
	: DataPacket( dataPacket ), _pipelineTimeStamp( dataPacket.pipelineTimeStamp() ), _pipelineVersion( dataPacket.pipelineVersion() )
	{}

	Int64	PTSSyncPacket::pipelineTimeStamp	() const	{ return this->_pipelineTimeStamp;	}
	Int64&	PTSSyncPacket::pipelineTimeStamp	()			{ return this->_pipelineTimeStamp;	}
	UInt8	PTSSyncPacket::pipelineVersion		() const	{ return this->_pipelineVersion;	}
	UInt8&	PTSSyncPacket::pipelineVersion		()			{ return this->_pipelineVersion;	}

	PTSSyncPacket::operator std::string () const
	{
		std::stringstream formatedOutput;
		
		formatedOutput
			<< "{\"ts\":"	<< this->timeStamp()
			<< ",\"s\":"	<< this->status()
			<< ",\"pts\":"	<< this->pipelineTimeStamp()
			<< ",\"pv\":"	<< this->pipelineVersion()
		<< "}";

		return formatedOutput.str();
	}

	PTSSyncPacket& PTSSyncPacket::operator= ( const PTSSyncPacket& dataPacket )
	{
		this->DataPacket::operator=( dataPacket );
		this->pipelineTimeStamp() = dataPacket.pipelineTimeStamp();
		this->pipelineVersion()   = dataPacket.pipelineVersion();
		return (*this);
	}

	// END CLASS PTS-SYNC-PACKET
	// ##################################################

	// ##################################################
	// ###          CLASS VTS-SYNC-PACKET             ###
	// ##################################################

	VTSSyncPacket::VTSSyncPacket ( Int64 timeStamp, UInt8 status, Int64 videoTimeStamp )
	: DataPacket( timeStamp, status, "vts" ), _videoTimeStamp( videoTimeStamp )
	{}

	VTSSyncPacket::VTSSyncPacket ( const VTSSyncPacket& dataPacket )
	: DataPacket( dataPacket ), _videoTimeStamp( dataPacket.videoTimeStamp() )
	{}

	Int64	VTSSyncPacket::videoTimeStamp	() const	{ return this->_videoTimeStamp;	}
	Int64&	VTSSyncPacket::videoTimeStamp	()			{ return this->_videoTimeStamp;	}

	VTSSyncPacket::operator std::string () const
	{
		std::stringstream formatedOutput;

		formatedOutput
			<< "{\"ts\":"	<< this->timeStamp()
			<< ",\"s\":"	<< this->status()
			<< ",\"vts\":"	<< this->videoTimeStamp()
		<< "}";

		return formatedOutput.str();
	}

	VTSSyncPacket& VTSSyncPacket::operator= ( float videoTimeStamp )
	{
		this->videoTimeStamp() = videoTimeStamp;
		return (*this);
	}

	VTSSyncPacket& VTSSyncPacket::operator= ( const VTSSyncPacket& dataPacket )
	{
		this->DataPacket::operator=( dataPacket );
		this->videoTimeStamp() = dataPacket.videoTimeStamp();
		return (*this);
	}

	// END CLASS VTS-SYNC-PACKET
	// ##################################################

	// ##################################################
	// ###      STREAM CONCATENATION OPERATORS        ###
	// ##################################################

	std::ostream& operator<< ( std::ostream& stream, const DataPacket& packet )
	{
		return stream << static_cast< std::string >( packet );
	}

	std::ostream& operator<< ( const DataPacket& packet, std::ostream& stream )
	{
		return stream << static_cast< std::string >( packet );
	}
		
	std::ostream& operator<< ( std::ostream& stream, const DataPacketPtr& packet )
	{
		return stream << static_cast< std::string >( *packet );
	}
	
	std::ostream& operator<< ( const DataPacketPtr& packet, std::ostream& stream )
	{
		return stream << static_cast< std::string >( *packet );
	}
	
	// END STREAM CONCATENATION OPERATORS
	// ##################################################

} // END NAMESPACE TOBII
// ##################################################

#endif // TOBII_DATAPACKETS_CPP
// ##################################################