// ##################################################
// ###          MATCHING_PATCHTOOLS_HPP           ###
// ##################################################
#ifndef MATCHING_PATCHTOOLS_HPP
#define MATCHING_PATCHTOOLS_HPP

// ##################################################
// ###                DEPENDANCES                 ###
// ##################################################

#include <list>
#include <map>
#include <opencv2/core/core.hpp>
#include <opencv2/imgproc/imgproc.hpp>
#include <opencv2/highgui/highgui.hpp>
#include <iostream>

// ##################################################
// ###            NAMESPACE PTOOLS                ###
// ##################################################

namespace PTools {

	using BlobMap = std::map< int, cv::Rect >;
	using UChar   = unsigned char;

	BlobMap extractBlobs ( const cv::Mat& binaryImage );

	// typedef MatArray std::vector< cv:Mat >;

	// MatArray	scaleSample  ( cv::Mat   sample,  int nbSmoothingLevels = 5, int kernelSize = 5, double sigma = 5 );
	// MatArray&	scaleSamples ( MatArray& samples, int nbSmoothingLevels = 5, int kernelSize = 5, double sigma = 5 );
	
	// /**
	//  * \brief Create a set of augmented samples
	//  * \param sample (cv::Mat) Image sample to augment
	//  * \param nbSmothingLevels (int) Number of smoothing levels
	//  * \param smoothingFactor (double) Standard deviation of the gaussian smoothing, cumulated at each level.
	//  * \param alpha (double) Angle between angmented sample
	//  * \return (MatArray) The set of augmented samples
	//  *
	//  * The augmentted set is the result of the smoothing at different levels,
	//  * and rotation with different angles of the given sample.
	//  * The total number of sample produced is: nbSmoothingLevels * (360 / alpha)
	//	*/
	// MatArray augmentSample ( cv::Mat sample, int nbSmoothingLevels = 5, double smoothingFactor = 5, double alpha = 90 );

} // END NAMESPACE PTOOLS
// ##################################################

#endif // MATCHING_PATCHTOOLS_HPP
// ##################################################