// ##################################################
// ###          MATCHING_PATCHTOOLS_CPP           ###
// ##################################################
#ifndef MATCHING_PATCHTOOLS_CPP
#define MATCHING_PATCHTOOLS_CPP

// ##################################################
// ###                DEPENDANCES                 ###
// ##################################################

#include "PatchTools.hpp"

// ##################################################
// ###             NAMESPACE PTOOLS               ###
// ##################################################

namespace PTools {

	

	BlobMap extractBlobs ( const cv::Mat& binaryImage )
	{
		// Blobs are sorted in a std::map, indexed by the area of the associated blob
		std::map< int, cv::Rect > blobs;

		// Label image, to account for pixels already processed
		cv::Mat labelImage = cv::Mat::zeros( binaryImage.size(), CV_8UC1 );
		int label( 1 );

		for ( int x(0) ; x < binaryImage.cols ; ++x )
		for ( int y(0) ; y < binaryImage.rows ; ++y )
		{
			// If we encounter a blob:
			if ( binaryImage.at<UChar>(y, x) == 255 && labelImage.at<UChar>(y, x) == 0 )
			{
				// Init a new blob:
				cv::Point topLeft(x, y), bottomRight(x, y);
				std::list< cv::Point > lstToProcess( 1, cv::Point(x, y) );

				// go in the neigh
				while ( lstToProcess.size() != 0 )
				{
					// Pop a point
					cv::Point current = lstToProcess.front();
					lstToProcess.pop_front();
					// std::cout << "current= (" << current.x << ", " << current.y << ")" << std::endl;

					// Update min point if needed
					if ( current.x < topLeft.x )
						topLeft.x = current.x;
					if ( current.y < topLeft.y )
						topLeft.y = current.y;

					// Update max point if needed
					if ( current.x > bottomRight.x )
						bottomRight.x = current.x;
					if ( current.y > bottomRight.y )
						bottomRight.y = current.y;

					// Update label image
					labelImage.at<UChar>(current.y, current.x) = label;

					// Look in the neighborhood
					for ( int dx(-1) ; dx <= 1 ; ++dx )
					for ( int dy(-1) ; dy <= 1 ; ++dy )
					{
						cv::Point neib(current.x+dx, current.y+dy);

						// check the image bounds
						if( 0 <= neib.x && neib.x < binaryImage.cols && 0 <= neib.y && neib.y < binaryImage.rows )
						{
							// std::cout << "\tneib = (" << neib.x << ", " << neib.y << ") : " << (int)binaryImage.at< UChar >(neib.y, neib.x) << ", " << (int)labelImage.at< UChar >(neib.y, neib.x);
							
							// check the image and label value:
							if ( binaryImage.at<UChar>(neib.y, neib.x) == 255 && labelImage.at<UChar>(neib.y, neib.x) == 0 )
							{
								if ( std::find(lstToProcess.begin(), lstToProcess.end(), neib) == lstToProcess.end() )
								{
									// std::cout << " -> pushing it";
									lstToProcess.push_back( neib );
								}
								// else std::cout << " <- already stack";
							}
							// std::cout << std::endl;
						}
					}
					// cv::imshow( "CurrentLabelImage", labelImage );
					// cv::waitKey( 1 );
				} // end while

				// Remind this blob
				cv::Rect blob( topLeft.x, topLeft.y, bottomRight.x-topLeft.x+1, bottomRight.y-topLeft.y+1 );
				blobs.emplace( blob.area(), blob );
				// std::cout << "Adding a blob: (" << topLeft.x << ", "<< topLeft.y << ") -> (" << bottomRight.x << ", " << bottomRight.y << ")" << std::endl << std::endl;

				// Update label
				++label;
			
			} // end if == 255

		} // end image loop
		return blobs;
	}

	// MatArray scaleSample ( cv::Mat sample, int nbSmoothingLevels, int kernelSize, double sigma )
	// {
	// 	CV_Assert( sample.cols != 0 && sample.rows != 0 );

	// 	// Result sample list:
	// 	MatArray samples( nbSmoothingLevels, cv::mat::zeros(sample.size, sample.type()) );
		
	// 	// Keep the original sample
	// 	samples.at(0) = sample;

	// 	// Compute the blurred copy of the sample
	// 	for ( int index(1) ; index < nbSmoothingLevels ;; ++index )
	// 	{
	// 		// Do it
	// 		cv::GaussianBlur( sample, samples.at(index), cv::Size(kernelSize,kernelSize), sigma );

	// 		// Increase the blurring
	// 		sigma += sigma;
	// 	}
	// 	return samples;
	// }

	// MatArray& scaleSamples ( MatArray& samples, int nbSmoothingLevels, int kernelSize, double sigma )
	// {
	// 	// to not do an infinite loop, we keep the input size
	// 	int nbInput = samples.size();
	// 	for ( int idSample(0) ; idSample < nbInput ; ++idSample )
	// 	{
	// 		// Copute the pyramid for a given sample
	// 		MatArray res = scaleSample( samples.at(idSample), nbSmoothingLevels, kernelSize, sigma );

	// 		// Copy it at the end of the 'samples' vector
	// 		std::move( res.begin(), res.end(), std::back_inserter(samples) );
	// 	}
	// 	return samples;
	// }

	// MatArray augmentSample ( cv::Mat sample, int nbSmoothingLevels, double smoothingFactor, double alpha )
	// {
	// 	CV_Assert( sample.cols != 0 && sample.rows != 0 );

	// 	std::vector< cv:Mat > result;
	// }

} // END NAMESPACE PTOOLS
// ##################################################

#endif // MATCHING_PATCHTOOLS_CPP
// ##################################################