#include <iostream>
#include <QDir>
#include <QString>

#include "PatchTools.hpp"
#include "TobiiSDK/Saliency.hpp"

#define GetArg( index, defaultValue ) ( (index < argc) ? argv[index] : #defaultValue )

int main ( const int argc, const char* argv[] )
{
	// Arguments:
	QString imageName( GetArg(1, ./WorkSpace/Frame_6200_Video.png      ) );
	QString salcyName( GetArg(1, ./WorkSpace/Frame_6200_Saliency.png   ) );
	QString labelName( GetArg(2, ./WorkSpace/Frame_6200_Annotation.png ) );
	// QString direName ( argv[3] );

	// Load the image and label image
	cv::Mat image = cv::imread( imageName.toStdString(), CV_LOAD_IMAGE_COLOR     );
	cv::Mat salcy = cv::imread( salcyName.toStdString(), CV_LOAD_IMAGE_COLOR     );
	cv::Mat label = cv::imread( labelName.toStdString(), CV_LOAD_IMAGE_GRAYSCALE );

	cv::resize( image, image, cv::Size(960,540) );
	cv::resize( salcy, salcy, cv::Size(960,540) );
	cv::resize( label, label, cv::Size(960,540) );

	// QDir dir( outDirPath );
	// if ( !dir.exists() )
	// 	dir.mkpath( dir.absolutePath() );

	// QString prefix = QString("%1/%2_").arg(dir.absolutePath()).arg(QFileInfo(imageName).baseName());

	// Binarize the image:
	cv::Mat binaryImage;
	cv::threshold( label, binaryImage, 127, 255, cv::THRESH_BINARY );

	// cv::imshow( "Image", image );
	// cv::imshow( "Saliency", salcy );
	// cv::imshow( "LabelImage", label );
	// cv::waitKey(1);

	// Get the list of blobls
	PTools::BlobMap blobmap = PTools::extractBlobs( binaryImage );

	image = Tobii::Saliency::computeWeightedMap( Tobii::Frame(0,0,image), Tobii::Frame(0,0,salcy) );

	for ( auto& blob : blobmap )
	 	cv::rectangle( image, blob.second, cv::Scalar(0,0,255) );

	cv::imshow( "Image", image );
	cv::waitKey(0);

	return 0;
}




// int    nblevels    = atoi( GetArg(3, 3  ) );
// int    kernelSize  = atoi( GetArg(4, 5  ) );
// double sigma       = atof( GetArg(5, 0.0) );
// std::cout
// 	<< "PatchGenerator:" << std::endl
// 	<< '\t' << "Input image         : "	<< fileNameIn.toStdString() << std::endl
// 	<< '\t' << "Output directory    : "	<< outDirPath.toStdString() << std::endl
// 	<< '\t' << "Nb Smotthing levels : "	<< nblevels		<< std::endl
// 	<< '\t' << "Kernel Sizes        : "	<< kernelSize	<< std::endl
// 	<< '\t' << "Sigma               : "	<< sigma		<< std::endl;
// fileNameIn = QFileInfo(fileNameIn).baseName();
// for ( int index(0) ; index < nblevels ; ++index )
// {
// 	cv::Mat res;
// 	cv::GaussianBlur( image, res, cv::Size(kernelSize, kernelSize), 0 );
// 	sigma = kernelSize/2.0;
// 	QString fileNameOut = QString("%1/%2_kernelSize=kernelSize=%3_sigma=%4.png").arg(outDirPath).arg(fileNameIn).arg(kernelSize).arg(sigma);
// 	cv::imwrite( fileNameOut.toStdString(), res );
// 	kernelSize += 4;
// }