#ifndef LIVEHEATMAPAPP_CPP
#define LIVEHEATMAPAPP_CPP

#include "LiveWeightedMapApp.hpp"

LiveWeightedMapApp::LiveWeightedMapApp ( const int argc, const char* argv[] )
: FileApplication( argc, argv )
{
	this->parseOptions( argc, argv );
}

const Frame&	LiveWeightedMapApp::saliencyMap	() const	{ return this->_saliencyMap;	}
Frame&			LiveWeightedMapApp::saliencyMap	()			{ return this->_saliencyMap;	}
const Frame&	LiveWeightedMapApp::weightedMap	() const	{ return this->_weightedMap;	}
Frame&			LiveWeightedMapApp::weightedMap	()			{ return this->_weightedMap;	}

int LiveWeightedMapApp::run ()
{
	// Open the files
	this->FileApplication::run();

	// Main Loop
	while ( !this->hasFinished() )
	{
		this->mutex().lock();

		if ( this->weightedMap().cols > 0 && this->weightedMap().rows > 0 )
			this->displayFrame( this->weightedMap() );

		this->mutex().unlock();
	}
	return EXIT_SUCCESS;
}

void LiveWeightedMapApp::receiveSynkedData ( FramePtr ptrFrame, GazeFixationPtr ptrFixation )
{
	this->mutex().lock();
	this->ptrFrame() = ptrFrame;
	this->ptrFixation() = ptrFixation;

	if ( ptrFrame && ptrFixation )
	{
		// Compute
		this->saliencyMap() = Saliency::computeSaliencyMap ( *this->ptrFixation(), this->ptrFrame()->size() );
		this->weightedMap() = Saliency::computeWeightedMap ( *this->ptrFrame(),    this->saliencyMap()      );

		// Record in the output video / dump (if option is set)
		this->recordFrame( this->weightedMap() );
		this->dumpFrame( this->weightedMap(), ptrFrame->timeStamp() );
	}

	this->mutex().unlock();
}

#endif // LIVEHEATMAPAPP_CPP