#ifndef LIVESALIENCYMAPGPUAPP_CPP
#define LIVESALIENCYMAPGPUAPP_CPP

#include "LiveSaliencyMapGPUApp.hpp"

LiveSaliencyMapGPUApp::LiveSaliencyMapGPUApp ( const int argc, const char* argv[] )
: FileApplication( argc, argv )
{
	this->parseOptions( argc, argv );
}

const Frame&	LiveSaliencyMapGPUApp::saliencyMap	() const	{ return this->_saliencyMap;	}
Frame&			LiveSaliencyMapGPUApp::saliencyMap	()			{ return this->_saliencyMap;	}

int LiveSaliencyMapGPUApp::run ()
{
	//Launch a small computation in order to compile the cuda code
	cv::Mat cm1(1, 1, CV_32FC1, cv::Scalar(0, 0, 255));
	cv::Mat cm2(1, 1, CV_32FC1, cv::Scalar(0, 0, 255));
	cv::gpu::GpuMat m1, m2;
	m1.upload(cm1);
	m2.upload(cm2);
	cv::gpu::gemm(m1, m2, -4, m1, 2, m2);

	// Open the files
	this->FileApplication::run();

	// Main Loop
	while ( !this->hasFinished() )
	{
		this->mutex().lock();

		if ( this->saliencyMap().cols > 0 && this->saliencyMap().rows > 0 )
			this->displayFrame( this->saliencyMap() );

		this->mutex().unlock();
	}
	return EXIT_SUCCESS;
}

void LiveSaliencyMapGPUApp::receiveSynkedData ( FramePtr ptrFrame, GazeFixationPtr ptrFixation )
{
	this->mutex().lock();
	this->ptrFrame() = ptrFrame;
	this->ptrFixation() = ptrFixation;

	if ( ptrFrame && ptrFixation )
	{
		// Compute
		this->saliencyMap() = Saliency::computeSaliencyMapGPU( *this->ptrFixation(), this->ptrFrame()->size() );

		// Record in the output video / dump (if option is set)
		cv::cvtColor( this->saliencyMap(), this->saliencyMap(), CV_GRAY2RGB ); // cv::imwrite needs Mat of type CV_8UC3
		
		this->recordFrame( this->saliencyMap() );
		this->dumpFrame( this->saliencyMap(), ptrFrame->timeStamp() );
	}

	this->mutex().unlock();
}

#endif // LIVESALIENCYMAPGPUAPP_CPP
