#ifndef LIVESALIENCYMAPAPP_HPP
#define LIVESALIENCYMAPAPP_HPP

#include "TobiiSDK/FileApplication.hpp"
#include "TobiiSDK/Saliency.hpp"

using namespace Tobii;

class LiveSaliencyMapApp : public FileApplication
{
	Q_OBJECT
private:
	Frame _saliencyMap;

public:
	LiveSaliencyMapApp ( const int argc, const char* argv[] );
	
	const Frame&	saliencyMap	() const;
	Frame&			saliencyMap	();
	const Frame&	heatMap		() const;
	Frame&			heatMap		();

	virtual int run ();

public slots:
	virtual void receiveSynkedData ( FramePtr ptrFrame, GazeFixationPtr ptrFixation );

private:
	LiveSaliencyMapApp ( const LiveSaliencyMapApp& );
	LiveSaliencyMapApp& operator= ( const LiveSaliencyMapApp& );
};

#endif // LIVESALIENCYMAPAPP_HPP