#ifndef LIVEHEATMAPGPUAPP_CPP
#define LIVEHEATMAPGPUAPP_CPP

#include <chrono>
#include "LiveHeatMapGPUApp.hpp"

LiveHeatMapGPUApp::LiveHeatMapGPUApp ( const int argc, const char* argv[] )
: FileApplication( argc, argv )
{
	this->parseOptions( argc, argv );
}

const Frame&	LiveHeatMapGPUApp::saliencyMap	() const	{ return this->_saliencyMap;	}
Frame&			LiveHeatMapGPUApp::saliencyMap	()			{ return this->_saliencyMap;	}
const Frame&	LiveHeatMapGPUApp::heatMap		() const	{ return this->_heatMap;		}
Frame&			LiveHeatMapGPUApp::heatMap		()			{ return this->_heatMap;		}

int LiveHeatMapGPUApp::run ()
{

	//Launch a small computation in order to compile the cuda code
	cv::Mat cm1(1, 1, CV_32FC1, cv::Scalar(0, 0, 255));
	cv::Mat cm2(1, 1, CV_32FC1, cv::Scalar(0, 0, 255));
	cv::gpu::GpuMat m1, m2;
	m1.upload(cm1);
	m2.upload(cm2);
	cv::gpu::gemm(m1, m2, -4, m1, 2, m2);
 
	// Open the files
	this->FileApplication::run();

	// Main Loop
	while ( !this->hasFinished() )
	{
		this->mutex().lock();

		if ( this->heatMap().cols > 0 && this->heatMap().rows > 0 )
			this->displayFrame( this->heatMap() );

		this->mutex().unlock();
	}
	return EXIT_SUCCESS;
}

void LiveHeatMapGPUApp::receiveSynkedData ( FramePtr ptrFrame, GazeFixationPtr ptrFixation )
{
	this->mutex().lock();
	this->ptrFrame() = ptrFrame;
	this->ptrFixation() = ptrFixation;

	if ( ptrFrame && ptrFixation )
	{
		// Compute
		auto chrono1 = std::chrono::steady_clock::now();
		this->saliencyMap() = Saliency::computeSaliencyMapGPU( *this->ptrFixation(), this->ptrFrame()->size() );
		auto chrono2 = std::chrono::steady_clock::now();
		this->heatMap()     = Saliency::computeHeatMapGPU( *this->ptrFrame(), this->saliencyMap(), 0.6 );
		auto chrono3 = std::chrono::steady_clock::now();

		std::cout << "Saliency:" << std::chrono::duration_cast<std::chrono::microseconds>(chrono2 - chrono1).count() << "\n"
					<< "Heat:" << std::chrono::duration_cast<std::chrono::microseconds>(chrono3 - chrono2).count() << "\n";

		// Record in the output video / dump (if option is set)
		this->recordFrame( this->heatMap() );
		this->dumpFrame( this->heatMap(), ptrFrame->timeStamp() );
	}

	this->mutex().unlock();
}

#endif // LIVEHEATMAPGPUAPP_CPP
