#ifndef LIVEHEATMAPAPP_HPP
#define LIVEHEATMAPAPP_HPP

#include "TobiiSDK/FileApplication.hpp"
#include "TobiiSDK/Saliency.hpp"

using namespace Tobii;

class LiveHeatMapApp : public FileApplication
{
	Q_OBJECT
private:
	Frame _saliencyMap, _heatMap;

public:
	LiveHeatMapApp ( const int argc, const char* argv[] );
	
	const Frame&	saliencyMap	() const;
	Frame&			saliencyMap	();
	const Frame&	heatMap		() const;
	Frame&			heatMap		();

	virtual int run ();

public slots:
	virtual void receiveSynkedData ( FramePtr ptrFrame, GazeFixationPtr ptrFixation );

private:
	LiveHeatMapApp ( const LiveHeatMapApp& );
	LiveHeatMapApp& operator= ( const LiveHeatMapApp& );
};

#endif // LIVEHEATMAPAPP_HPP