#ifndef LIVEHEATMAPAPP_CPP
#define LIVEHEATMAPAPP_CPP

#include <chrono>
#include "LiveHeatMapApp.hpp"

LiveHeatMapApp::LiveHeatMapApp ( const int argc, const char* argv[] )
: FileApplication( argc, argv )
{
	this->parseOptions( argc, argv );
}

const Frame&	LiveHeatMapApp::saliencyMap	() const	{ return this->_saliencyMap;	}
Frame&			LiveHeatMapApp::saliencyMap	()			{ return this->_saliencyMap;	}
const Frame&	LiveHeatMapApp::heatMap		() const	{ return this->_heatMap;		}
Frame&			LiveHeatMapApp::heatMap		()			{ return this->_heatMap;		}

int LiveHeatMapApp::run ()
{
	// Open the files
	this->FileApplication::run();

	// Main Loop
	while ( !this->hasFinished() )
	{
		this->mutex().lock();

		if ( this->heatMap().cols > 0 && this->heatMap().rows > 0 )
			this->displayFrame( this->heatMap() );

		this->mutex().unlock();
	}
	return EXIT_SUCCESS;
}

void LiveHeatMapApp::receiveSynkedData ( FramePtr ptrFrame, GazeFixationPtr ptrFixation )
{
	this->mutex().lock();
	this->ptrFrame() = ptrFrame;
	this->ptrFixation() = ptrFixation;

	if ( ptrFrame && ptrFixation )
	{
		// Compute
		auto chrono1 = std::chrono::steady_clock::now();
		this->saliencyMap() = Saliency::computeSaliencyMap( *this->ptrFixation(), this->ptrFrame()->size() );
		auto chrono2 = std::chrono::steady_clock::now();
		this->heatMap()     = Saliency::computeHeatMap( *this->ptrFrame(), this->saliencyMap(), 0.6 );
		auto chrono3 = std::chrono::steady_clock::now();
		
		std::cout << "Saliency:" << std::chrono::duration_cast<std::chrono::microseconds>(chrono2 - chrono1).count() << "\n"
				  << "Heat:" << std::chrono::duration_cast<std::chrono::microseconds>(chrono3 - chrono2).count() << "\n";

		// Record in the output video / dump (if option is set)
		this->recordFrame( this->heatMap() );
		this->dumpFrame( this->heatMap(), ptrFrame->timeStamp() );
	}

	this->mutex().unlock();
}

#endif // LIVEHEATMAPAPP_CPP
