// ##################################################
// ###              TOBII_STARTPAGE_CPP           ###
// ##################################################
#ifndef TOBII_STARTPAGE_CPP
#define TOBII_STARTPAGE_CPP

// ##################################################
// ###                 DEPENDENCES                ###
// ##################################################

#include "StartPage.hpp"

// ##################################################
// ###              NAMESPACE TOBII               ###
// ##################################################

namespace Tobii {

	// ##################################################
	// ###              CLASS START-PAGE              ###
	// ##################################################

	const QString StartPage::IconOpen( "./Sources/Binaries/AnnotationTool/Ressources/open.png" );

	StartPage::StartPage ( const QString& worspace, const QString& categories, QWidget* ptrParent )
	: QDockWidget( ptrParent )
	{
		this->setupUi( this );
		this->lineWorkspace->setText( worspace );
		this->lineCategories->setText( categories );
		this->butWorkspace->setIcon( QIcon(StartPage::IconOpen) );
		this->butCategories->setIcon( QIcon(StartPage::IconOpen) );
	}

	const QVBoxLayout*	StartPage::recentProjectsLayout () const	{ return dynamic_cast< const QVBoxLayout* >( this->groupRecent->layout() ); }
	QVBoxLayout*		StartPage::recentProjectsLayout ()			{ return dynamic_cast<       QVBoxLayout* >( this->groupRecent->layout() ); }

	void StartPage::on_butNew_clicked		()	{ emit this->newProject();		}
	void StartPage::on_butImport_clicked	()	{ emit this->importProject();	}
	void StartPage::on_butOpen_clicked		()	{ emit this->openProject();		}

	void StartPage::on_butWorkspace_clicked ()
	{
		QString folder = QFileDialog::getExistingDirectory( this, tr("Choose the Workspace directory"), this->lineWorkspace->text(), QFileDialog::ShowDirsOnly );
	
		if ( ! folder.isEmpty() )
			this->lineWorkspace->setText( folder );
	}

	void StartPage::on_lineWorkspace_textChanged ( const QString& text )
	{
		emit this->workspaceChanged( text );
	}

	void StartPage::on_butCategories_clicked ()
	{
		QString folder = QFileDialog::getOpenFileName( this, tr("Choose the category file"), this->lineWorkspace->text(), tr("Text files (*.txt)") );
	
		if ( ! folder.isEmpty() )
			this->lineCategories->setText( folder );
	}
	void StartPage::on_lineCategories_textChanged ( const QString& text )
	{
		emit this->categoriesChanged( text );
	}

	// END CLASS START-PAGE
	// ##################################################

} // END NAMESPACE TOBII
// ##################################################

#endif // TOBII_STARTPAGE_CPP
// ##################################################
