// ##################################################
// ###            TOBII_PROJECTPAGE_HPP           ###
// ##################################################
#ifndef TOBII_PROJECTPAGE_HPP
#define TOBII_PROJECTPAGE_HPP

// ##################################################
// ###                 DEPENDENCES                ###
// ##################################################

// INTERNAL MODULES
#include "VideoDisplay.hpp"
#include "ControlePanel.hpp"
#include "TobiiSDK/Stream/Project.hpp"
#include "TobiiSDK/Saliency.hpp"

// EXTERNAL LIBRARIES
#include <QtWidgets>

// ##################################################
// ###              NAMESPACE TOBII               ###
// ##################################################

namespace Tobii {

	// ##################################################
	// ###            CLASS PROJECT-PAGE              ###
	// ##################################################

	class ProjectPage : public QDockWidget
	{
		Q_OBJECT
	private:
		QWidget*			_ptrContentWidget;
		QGridLayout*		_ptrLayout;
		ControlePanel*		_ptrControlePanel;
		VideoDisplay*		_ptrVideoDisplay;

		ProjectPtr			_ptrProject;
		QString				_selectedView;
		double				_scalingFactor;
		Int64				_timeStampFrom;
		Int64				_timeStampTo;
		double				_threshold;

	public:
		ProjectPage ( const QString& name = "", const QString& categoryFile = "", QWidget* ptrParent = NULL );

		const QWidget*			ptrContentWidget	() const;
		QWidget*				ptrContentWidget	();
		const QGridLayout*		ptrLayout			() const;
		QGridLayout*			ptrLayout			();
		const ControlePanel*	ptrControlePanel	() const;
		ControlePanel*&			ptrControlePanel	();
		const VideoDisplay*		ptrVideoDisplay		() const;
		VideoDisplay*&			ptrVideoDisplay		();

		const ProjectPtr&		ptrProject			() const;
		ProjectPtr&				ptrProject			();
		const QString&			selectedView		() const;
		QString&				selectedView		();
		double					scalingFactor		() const;
		double&					scalingFactor		();
		Int64					timeStampFrom		() const;
		Int64&					timeStampFrom		();
		Int64					timeStampTo			() const;
		Int64&					timeStampTo			();
		double					threshold			() const;
		double&					threshold			();
		
		void setProject	( ProjectPtr ptrProject );
		void setFrame	( const Frame& frame );

		virtual void closeEvent ( QCloseEvent* event );

	public slots:
		void open	( const QString& folder );
		void close	();
		void update	();

	private slots:
		void nextFrame			();
		void previousFrame		();
		void setSelectedView	( QString view );
		void setZoomFactor		( double factor );
		void pickFrameFrom		();
		void pickFrameTo		();
		void setThreshold		( double value );
		void computeAnnotation	();

		void changeCategory ( const QString& text );

	signals:
		void sizeChanged (const QSize&);

	#define TRACK_STATS 1
	#ifdef  TRACK_STATS
	private:
		Int64	_nbInstances;
		Int64	nbInstances	() const;
		Int64&	nbInstances	();

	private slots:
		void resetStatistics ();
		void saveStatistics ( int timeElapsed );
	#endif

	}; // END CLASS PROJECT-PAGE
	// ##################################################

} // END NAMESPACE TOBII
// ##################################################

#endif // TOBII_PROJECTPAGE_HPP
// ##################################################