// ##################################################
// ###          TOBII_IMPORTATIONWIZARD_CPP       ###
// ##################################################
#ifndef TOBII_IMPORTATIONWIZARD_CPP
#define TOBII_IMPORTATIONWIZARD_CPP

// ##################################################
// ###                 DEPENDENCES                ###
// ##################################################

#include "ImportationWizard.hpp"

// ##################################################
// ###              NAMESPACE TOBII               ###
// ##################################################

namespace Tobii {

	// ##################################################
	// ###         CLASS INTEPORTATION-WIZARD         ###
	// ##################################################

	ImportationWizard::ImportationWizard ( const QString& folder, QWidget* ptrParent )
	: QDialog( ptrParent ), _folder( folder )
	{
		this->setupUi( this );
	}

	const QString&	ImportationWizard::folder	() const	{ return this->_folder;	}
	QString&		ImportationWizard::folder	()			{ return this->_folder;	}

	void ImportationWizard::on_pbPickVideo_clicked()
	{
		QString videoFile = QFileDialog::getOpenFileName( this, "Chose the Tobii eye tracker video file please", this->folder(), tr("Video file (*.mp4)" ) );
		this->leVideoPath->setText( videoFile );

		if ( ! videoFile.isEmpty() )
		{
			QDir directory = QFileInfo(videoFile).absoluteDir();
			for ( const QFileInfo& fileinfo : directory.entryInfoList() )
			{
				if ( fileinfo.suffix() == "json" )
				{
					this->leGazePath->setText( fileinfo.absoluteFilePath() );

					if ( this->leName->text().isEmpty() )
						this->leName->setText( "Unknown/"+fileinfo.baseName() );
				}
			}
		}

	}

	void ImportationWizard::on_pbPickGaze_clicked()
	{
		QString gazeFile = QFileDialog::getOpenFileName( this, "Chose the Tobii eye tracker data file please", this->folder(), tr("JSON file (*.json)" ) );
		this->leGazePath->setText( gazeFile );

		if ( ! gazeFile.isEmpty() )
		{
			QDir directory = QFileInfo(gazeFile).absoluteDir();
			for ( const QFileInfo&  fileinfo : directory.entryInfoList() )
			{
				if ( fileinfo.suffix() == "mp4" )
				{
					this->leVideoPath->setText( fileinfo.absoluteFilePath() );

					if ( this->leName->text().isEmpty() )
						this->leName->setText( "Unknown/"+fileinfo.baseName() );
				}
			}
		}
	}

	void ImportationWizard::on_buttonBox_accepted()
	{
		// Gazer options that have been set
	    ImportationOptions options;

	    // General
	    options.name = leName->text();
	    
	    // Video
	    options.videoFileName = this->leVideoPath->text();
	   
	    // Résolution
	    QStringList resolution = this->cbResolution->currentText().split("x");
		options.resolution	   = cv::Size( resolution.at(0).toInt(), resolution.at(1).toInt() );

		// Gaze Data
		options.gazeFileName				= this->leGazePath->text();
		options.importAccelerometerRecords	= this->cbImportAcc->isChecked();
		options.importGyroscopeRecords		= this->cbImportGy->isChecked();
		options.keepAllRecordings			= this->cbKeepAll->isChecked();
		options.forceInterpolation			= this->cbForceInterp->isChecked();
		options.recomputeDistance			= this->cbRecomputeDist->isChecked();

		// Other Options
		options.computeSaliencyMaps		= this->cbSaliency->isChecked();
		options.computeHeatFrames		= this->cbHeat->isChecked();
		options.computeWeightedFrames	= this->cbWeighted->isChecked();

		// Check if the files have been selected
		if ( options.name.isEmpty() || options.videoFileName.isEmpty() || options.gazeFileName.isEmpty() )
		{
			QMessageBox msg( this );
			msg.setText( "Please choose a \"Name\", and select both a \"Video File\" and a \"Gaze data File\", or press \"Cancel\"." );
			msg.addButton( "Ok", QMessageBox::AcceptRole );
			msg.addButton( "Cancel", QMessageBox::RejectRole );
			int ret = msg.exec();

			if ( ret == QMessageBox::RejectRole )
				this->reject();
		}
		else
		{
			// Emit the options
			emit this->accepted( options );

			// Close this window
			this->accept();
		}
	}

	void ImportationWizard::on_buttonBox_rejected()
	{
	    this->close();
	}

	void ImportationWizard::on_cbSaliency_stateChanged	( int state )
	{
		if ( state != Qt::Checked )
		{
			this->cbHeat->setCheckState( Qt::Unchecked );
			this->cbWeighted->setCheckState( Qt::Unchecked );
		}
	}
	 
	void ImportationWizard::on_cbHeat_stateChanged	( int state )
	{
		if ( state == Qt::Checked  )
			this->cbSaliency->setCheckState( Qt::Checked );
	}

	void ImportationWizard::on_cbWeighted_stateChanged	( int state )
	{
		if ( state == Qt::Checked  )
			this->cbSaliency->setCheckState( Qt::Checked );
	}

	// END CLASS INTEPORTATION-WIZARD
	// ##################################################

} // END NAMESPACE TOBII
// ##################################################

#endif // TOBII_MAINWINDOW_CPP
// ##################################################
