// ##################################################
// ###          TOBII_EXPORTATIONWIZARD_HPP       ###
// ##################################################
#ifndef TOBII_EXPORTATIONWIZARD_HPP
#define TOBII_EXPORTATIONWIZARD_HPP

// ##################################################
// ###                 DEPENDENCES                ###
// ##################################################

// EXTERNAL LIBRARIES
#include <QtWidgets>

// GENERATED HEADERS
#include "ui_ExportationWizard.h"

// INTERNAL MODULES
#include "TobiiSDK/ExportationOptions.hpp"

// ##################################################
// ###              NAMESPACE TOBII               ###
// ##################################################

namespace Tobii {

	// ##################################################
	// ###         CLASS INTEPORTATION-WIZARD         ###
	// ##################################################

	class ExportationWizard : public QDialog, private Ui::ExportationWizard
	{
	    Q_OBJECT
	public:
		ExportationWizard ( QWidget* ptrParent = NULL );

	private slots:
	    void on_pbPickFolder_clicked ();
	    void on_buttonBox_accepted	 ();
	    void on_buttonBox_rejected	 ();

	signals:
		void accepted ( ExporationOptions options );

	public:
		static ExporationOptions execute ();
	
	}; // END CLASS INTEPORTATION-WIZARD
	// ##################################################

	class ExporterListener : QObject
	{
		Q_OBJECT
	public:
		ExportationWizard*	ptrWizard;
		ExporationOptions	options;

		ExporterListener ();

	private slots:
		void receive ( ExporationOptions options );

	};

} // END NAMESPACE TOBII
// ##################################################

#endif // TOBII_EXPORTATIONWIZARD_HPP
// ##################################################
