// ##################################################
// ###          TOBII_EXPORTATIONWIZARD_CPP       ###
// ##################################################
#ifndef TOBII_EXPORTATIONWIZARD_CPP
#define TOBII_EXPORTATIONWIZARD_CPP

// ##################################################
// ###                 DEPENDENCES                ###
// ##################################################

#include "ExportationWizard.hpp"

// ##################################################
// ###              NAMESPACE TOBII               ###
// ##################################################

namespace Tobii {

	// ##################################################
	// ###         CLASS INTEPORTATION-WIZARD         ###
	// ##################################################


	ExportationWizard::ExportationWizard ( QWidget* ptrParent )
	: QDialog( ptrParent )
	{
		this->setupUi( this );
	}

    void ExportationWizard::on_pbPickFolder_clicked ()
    {
    	QString dir = QFileDialog::getExistingDirectory( this, "Chose the exportation directory please", QDir::homePath() );
    	this->leExpFolder->setText( dir );
    }

    void ExportationWizard::on_buttonBox_accepted ()
    {
    	ExporationOptions options;

    	// Directory
    	options.directory = this->leExpFolder->text();

		// Options:
		options.exportAs           = this->cbExportAs->currentText();
		options.exportVideo        = this->cbExpVideo->isChecked();
		options.exportGazeData     = this->cbExpGaze->isChecked();
		options.exportAcceleration = this->cbExpAcc->isChecked();
		options.exportOrientation  = this->cbExpGyro->isChecked();
		options.exportAllData      = this->cbExpAll->isChecked();
		options.exportSaliency     = this->cbExpSaliency->isChecked();
		options.exportHeatMap      = this->cbExpHeat->isChecked();
		options.exportWeighted     = this->cbExpWeighted->isChecked();

    	// Check if the files have been selected
		if ( options.directory.isEmpty()  )
		{
			QMessageBox msg( this );
			msg.setText( "Please choose a \"Directory\" where to export, or press \"Cancel\"." );
			msg.addButton( "Ok", QMessageBox::AcceptRole );
			msg.addButton( "Cancel", QMessageBox::RejectRole );
			int ret = msg.exec();

			if ( ret == QMessageBox::RejectRole )
				this->close();
		}
		else
		{
			// Emit the options
			emit this->accepted( options );

			// Close this window
			this->close();
		}
    }

    void ExportationWizard::on_buttonBox_rejected ()
    {
    	this->close();
    }

	ExporationOptions ExportationWizard::execute ()
	{
		ExporterListener exporter;
		
		if ( exporter.ptrWizard->exec() == QMessageBox::AcceptRole )
			exporter.options.accepted = true;

		return exporter.options;
	}
	
	// END CLASS INTEPORTATION-WIZARD
	// ##################################################

	ExporterListener::ExporterListener ()
	: ptrWizard( new ExportationWizard() )
	{
		connect( this->ptrWizard, SIGNAL(accepted(ExporationOptions)), this, SLOT(receive(ExporationOptions)) );
	}

	void ExporterListener::receive ( ExporationOptions options )
	{
		this->options = options;
	}

} // END NAMESPACE TOBII
// ##################################################

#endif // TOBII_EXPORTATIONWIZARD_CPP
// ##################################################
