#include"MainApp.h"

#include<map>
#include"TobiiGlassesSDK.h"
#include"GoProManager.h"
#include <thread>

Tobii::GlassesSDK * glasses = NULL;

void intHandler(int sig) {
	glasses->stopLiveStream();
	signal(sig, SIG_IGN);
}

void video_cb(cv::Mat & image, const int64_t pts) {
	//std::cout << "pts: " << pts << " - main::Received image" << std::endl;
}

void data_cb(std::string & data) {
	std::cout << "main::Received data: " << data << std::endl;
}

void data_filled_cb(Tobii::Data & d, unsigned int sizeBuffer, char flag) {
	if(flag & Tobii::DATA_IS_TRACKING) {
		std::map<int64_t, Tobii::DataRow>::iterator it;
		size_t size = d.bufferData.size();
		for (it=d.bufferData.begin(); it!=d.bufferData.end(); ++it) {
			if(it->second.check_flags == Tobii::DATAROW_FIXATION_FILLED) {
	//	    		std::cout << it->first << ", GP: " << it->second.gazePosition2D[0] << ", " << it->second.gazePosition2D[1] << std::endl;
			}
		}
		// cleaning the data buffer in order to keep only sizeBuffer elements
		if(size>sizeBuffer) {
			it = d.bufferData.begin();
			std::advance(it, size - sizeBuffer);
			d.bufferData.erase(d.bufferData.begin(), it);
		}
		//std::cout << "/!\\ Data completely filled /!\\" << std::endl;
		//std::cout << "there are " << d.bufferData.size() << " elements on the data buffer." << std::endl;
	}else if(flag & Tobii::DATA_IS_FRAME){
		std::map<int64_t, Tobii::DataRowFrame>::iterator it;
		size_t size = d.bufferFrames.size();
		for (it=d.bufferFrames.begin(); it!=d.bufferFrames.end(); ++it) {
			//std::cout << "frame pts: " << it->first << std::endl;
		}
		// cleaning the frames buffer in order to keep only sizeBuffer elements
		if(size>sizeBuffer) {
			it = d.bufferFrames.begin();
			std::advance(it, size - sizeBuffer);
			d.bufferFrames.erase(d.bufferFrames.begin(), it);
		}
		//std::cout << "there are " << d.bufferFrames.size() << " elements on the frame buffer." << std::endl;
	}else if(flag & Tobii::DATA_IS_SYNC) {
		//std::cout << "Sync packet received." << std::endl;
		// do something cool about sync, or just know that there is a new syncing data.
	}
}


int processGoPro (string myurl =  "http://10.5.5.9/bacpac/"  , string mypswd = "GoProhero1" )
{
    GoProManager * mygopro = NULL;
    int mode = 1;
    // string myurl = "http://10.5.5.9/bacpac/";
    //string mypswd = "GoProMyl";
    // GoProManager mygopro(myurl, mypswd); // set URL & password
    mygopro = new GoProManager(myurl,mypswd);
    mygopro->init_curl();
    while (mode > 0 && mode < 4)
    {
        cout << "1- Change mode" <<endl;
        cout << "2- Start Capture" << endl;
        cout << "3- Stop Capture"<<endl;
        cin >> mode;
        mygopro->process_request(mode);
    }
    mygopro->exit_curl();
    delete mygopro;
    exit(EXIT_SUCCESS);

}

int processTobii(char* glassesIPAddress, int sizeBuffer)
{
  struct sigaction act;
  memset(glassesIPAddress, 0, 64*sizeof(char));
  act.sa_handler = intHandler;
  sigaction(SIGINT, &act, NULL);

  
  // unsigned int sizeBuffer = atoi(argv[2]);
  glasses = new Tobii::GlassesSDK(glassesIPAddress, sizeBuffer);
  glasses->setVideoCallback(&video_cb);
  glasses->setDataCallback(&data_cb);
  glasses->setDataFilledCallback(&data_filled_cb);
  if(glasses->discovery(true)) {
    glasses->livestream(TOBII_LIVE_ON_WINDOW);
    // ou opencv   
  }
  delete glasses;
  exit(EXIT_SUCCESS);
}

int main(int argc, char ** argv) { // création de deux thread, un pour afficher les tobi l'autre pour afficher les gopro
    if(argc!=5) {
    std::cout << "Usage: " << argv[0] << "<Tobii IP address> <Buffer size> <muyrlGopro> <mypswdGoPro>" << std::endl;
    return EXIT_FAILURE;
  }
   unsigned int sizeBuffer = atoi(argv[2]);
   char glassesIPAddress[64];
   strncpy(glassesIPAddress,argv[1], strlen(argv[1]));
   string myurl = argv[3];
   string mypswd = argv[4];
   
   std::thread gopro (processGoPro, myurl, mypswd);    
   std::thread tobii (processTobii, glassesIPAddress, sizeBuffer); 


  // synchronize threads:
  gopro.join();                // pauses until first finishes
  tobii.join();               // pauses until second finishes


    exit(EXIT_SUCCESS);
    
}

