# - Try to find Restclient-cpp 
# Once done, it will define
#
# Restclient-cpp_FOUND - system has Restclient-cpp
# Restclient-cpp_FOUND_INCLUDE_DIRS - Restclient-cpp include directories
# Restclient-cpp_FOUND_DEFINITIONS - Compiler switches required for using Restclient-cpp
# Restclient-cpp_FOUND_LIBRARIES - link these to use Restclient-cpp

#include(LibFindMacros)



IF (Restclient-cpp_INCLUDE_DIRS AND Restclient-cpp_LIBRARIES)
  # in cache already
  SET(Restclient-cpp_FIND_QUIETLY TRUE)
ENDIF (Restclient-cpp_INCLUDE_DIRS AND Restclient-cpp_LIBRARIES)


IF(APPLE)
  INCLUDE(CMakeFindFrameworks)
  CMAKE_FIND_FRAMEWORKS(Restclient-cpp2)
  
  IF(Restclient-cpp_FRAMEWORKS)
    FOREACH(dir ${Restclient-cpp_FRAMEWORKS})
      SET(Restclient-cpp_FMWK_INCLUDES ${Restclient-cpp_FMWK_INCLUDES} ${dir}/Headers) #add ${dir}/PrivateHeaders ???
    ENDFOREACH(dir)

    find_path(Restclient-cpp_INCLUDE_DIR
      NAMES Restclient-cpp.hpp
      PATHS ${Restclient-cpp_FMWK_INCLUDES}
      )

    SET(Restclient-cpp_LIBRARY "-framework Restclient-cpp")
  ENDIF(Restclient-cpp_FRAMEWORKS)
ENDIF(APPLE)


IF(NOT Restclient-cpp_LIBRARY OR NOT APPLE)

  ##On apple, we want framework to be of higher priority
  # but on linux, if we don't always do this, Restclient-cpp_DEFINITIONS is not defined the second time we run cmake
  # TODO: investigate...



  #libfind_pkg_check_modules(Restclient-cpp_PKGCONF Restclient-cpp)
  IF (NOT WIN32)
    include(FindPkgConfig)
    pkg_check_modules(Restclient-cpp_PKGCONF Restclient-cpp)
    SET(Restclient-cpp_DEFINITIONS ${Restclient-cpp_DEFINITIONS} ${Restclient-cpp_PKGCONF_CFLAGS_OTHER})
  ENDIF (NOT WIN32)


  # Include dir
  find_path(Restclient-cpp_INCLUDE_DIR
    NAMES Restclient-cpp.hpp
    PATHS ${Restclient-cpp_PKGCONF_INCLUDE_DIRS})

  # Library
  find_library(Restclient-cpp_LIBRARY
    NAMES Restclient-cpp
    PATHS ${Restclient-cpp_PKGCONF_LIBRARY_DIRS})

ENDIF()



INCLUDE(FindPackageHandleStandardArgs)


# handle the QUIETLY and REQUIRED arguments and set Restclient-cpp_FOUND to TRUE if 
# all listed variables are TRUE
FIND_PACKAGE_HANDLE_STANDARD_ARGS(Restclient-cpp DEFAULT_MSG Restclient-cpp_LIBRARY Restclient-cpp_INCLUDE_DIR)

IF (Restclient-cpp_FOUND)
  set(Restclient-cpp_INCLUDE_DIRS ${Restclient-cpp_INCLUDE_DIR})
  set(Restclient-cpp_LIBRARIES ${Restclient-cpp_PKGCONF_LDFLAGS_OTHER} ${Restclient-cpp_LIBRARY})
  
ENDIF (Restclient-cpp_FOUND)


MARK_AS_ADVANCED(Restclient-cpp_INCLUDE_DIRS Restclient-cpp_LIBRARIES)

