#include<map>

#include"TobiiGlassesSDK.h"
#include"MainApp.h"

void intHandler(int sig);

void video_cb(Tobii::Frame * image, const int64_t pts);
void data_cb(std::string & data);

void data_filled_cb(Tobii::Data & d, unsigned int sizeBuffer, char flag);

Tobii::GlassesSDK* glasses = NULL;

int main(int argc, char** argv)
{
	// Check arguments
	if( argc > 3 )
	{
		std::cout << "Usage: " << argv[0] << "<Tobii IP address> <Buffer size>" << std::endl;
		std::cout << "\tAll arguments are optional." << std::endl;
		return EXIT_FAILURE;
	}

	// Arguments default values
	std::string glassesIPAddress( "192.168.71.50" );
	unsigned int sizeBuffer( 10 );

	// Read arguments if they are specified
	if ( argc > 1 )
		glassesIPAddress = argv[1];
	if ( argc > 2 )
		sizeBuffer = atoi( argv[2] );

	// Signal handler
	struct sigaction act;
	act.sa_handler = intHandler;
	sigaction(SIGINT, &act, NULL);

	// Init glasses
	glasses = new Tobii::GlassesSDK( glassesIPAddress.c_str(), sizeBuffer );
	glasses->setVideoCallback(&video_cb);
	glasses->setDataCallback(&data_cb);
	glasses->setDataFilledCallback(&data_filled_cb);
	if(glasses->discovery(true))
	{
		glasses->livestream(TOBII_LIVE_ON_OPENCV); // mainloop
	}
	if(glasses)
		delete glasses;
	return 0;
}

void intHandler(int sig)
{
	glasses->stopLiveStream();
	delete glasses;
	glasses = NULL;
	signal(sig, SIG_IGN);
}

void video_cb(Tobii::Frame* image, const int64_t pts)
{
	std::cout << "video_cb : pts= " << pts << "." << std::endl;
	
	/*if ( image->getImage()->width != 0 && image->getImage()->height != 0 )
	{
		cv::Mat frame( image->getImage(), true );
		cv::imshow( "tobii", frame );
		cv::waitKey(1);
	}
	else
		std::cout << "empty frame" << std::endl;*/
}

void data_cb(std::string & data)
{
	std::cout << "data_cb : data= " << data << "." << std::endl;
}

void data_filled_cb(Tobii::Data& d, unsigned int sizeBuffer, char flag)
{
	if(flag & Tobii::DATA_IS_TRACKING)
	{
		std::map<int64_t, Tobii::DataRow>::iterator it;
		size_t size = d.bufferData.size();
		for (it=d.bufferData.begin(); it!=d.bufferData.end(); ++it) {
			if(it->second.check_flags == Tobii::DATAROW_FIXATION_FILLED) {
		    		std::cout << it->first << ", GP: " << it->second.gazePosition2D[0] << ", " << it->second.gazePosition2D[1] << std::endl;
		    		std::cout << it->first << ", GP3: " << it->second.gazePosition3D[0] << ", " << it->second.gazePosition3D[1] << ", " << it->second.gazePosition3D[2] << std::endl;
			}
		}
		
		// std::cout << "/!\\ Data completely filled /!\\" << std::endl;
		std::cout << "there are " << d.bufferData.size() << " elements on the data buffer." << std::endl;
	}
	else if(flag & Tobii::DATA_IS_FRAME)
	{
		std::map<int64_t, Tobii::DataRowFrame>::iterator it;
		size_t size = d.bufferFrames.size();
		for (it=d.bufferFrames.begin(); it!=d.bufferFrames.end(); ++it) {
			//std::cout << "frame pts: " << it->first << std::endl;
		}
		std::cout << "Received Frame" << std::endl;
		
		std::cout << "there are " << d.bufferFrames.size() << " elements on the frame buffer." << std::endl;
	}
	else if( flag & Tobii::DATA_IS_SYNC )
	{
		//std::cout << "Sync packet received." << std::endl;
		// do something cool about sync, or just know that there is a new syncing data.
	}
}
