/******************************************************
 * This is a port in C++11 of the Tobii Glasses 2 SDK *
 * This will ensure an easy access to the Tobii Glass *
 * Author: Pierre-Marie Plans                         *
 * E-mail: pierre.plans@gmail.com                     *
 ******************************************************/

#ifndef FRAME_H_
#define FRAME_H_


/**
 * \file Frame.h
 * \brief This class handles the Tobii Glasses 2 frames coming by streaming.
 * \author Pierre-Marie Plans
 * \date 09/10/2015
 **/
#include <opencv2/opencv.hpp>

/**
 * \namespace Tobii
 * \brief Contains all the tools relative to Glasses 2 SDK
 **/

namespace Tobii {
	static int Count = 0;
	static unsigned int FrameIdCounter = 0;

	/**
	 * \class Frame
	 * \brief Frame encapsulate the OpenCV Frames
	 * 
	 **/
	class Frame {
		IplImage *m_cvFrame;
		int64_t m_pts;
		unsigned int m_id;
		public:
			Frame(unsigned int width, unsigned int height, unsigned int channels);
			Frame(const Frame & frame);
			Frame();
			~Frame();
			IplImage* getImage() const;
			unsigned int getId() const;
			int64_t getPTS() const;
			void setData(char * data);
			void setPTS(int64_t);
			cv::Mat asCVMat();
			int toFile(const char * filePath);
	};
}
#endif
