#include "Frame.h"

Tobii::Frame::Frame(unsigned int width, unsigned int height, unsigned int channels) {
	m_cvFrame = cvCreateImageHeader(cvSize(width, height), IPL_DEPTH_8U, channels);
	Tobii::Count++;
	m_id = Tobii::FrameIdCounter++;
	std::cout << "Frame::Frame("<<width<<","<<height<<","<<channels<<")"<<std::endl;
}

Tobii::Frame::Frame(const Frame & frame) {
	m_cvFrame = frame.getImage();
	m_id = frame.getId();
	m_pts = frame.getPTS();
	std::cout << "Frame::Frame("<<frame.getId()<<")"<<std::endl;
}

Tobii::Frame::Frame() {
	m_cvFrame = NULL;
}

Tobii::Frame::~Frame() {
	cvReleaseImage(&m_cvFrame);
	delete m_cvFrame;
	m_cvFrame = NULL;
	Tobii::Count--;
	std::cout << "Frame::~Frame()"<<std::endl;
}

IplImage* Tobii::Frame::getImage() const {
	return m_cvFrame;
}

unsigned int Tobii::Frame::getId() const {
	return m_id;
}

int64_t Tobii::Frame::getPTS() const {
	return m_pts;
}

void Tobii::Frame::setData(char * data) {
	m_cvFrame->imageData;
}

void Tobii::Frame::setPTS(int64_t pts) {
	m_pts = pts;
}

cv::Mat Tobii::Frame::asCVMat() {
	return cv::Mat(m_cvFrame);
}

int Tobii::Frame::toFile(const char * filePath) {
	try {
		cv::imwrite(filePath, asCVMat());
	}catch (const std::exception & ex) {
		std::cerr << "Frame::Exception saving Frame to file " << filePath << ": "<< ex.what() << std::endl;
		return 0;
	}
	return 1;
}

