# - Try to find Glib-2.0 (with gobject)
# Once done, this will define
#
#  Glib_FOUND - system has Glib
#  Glib_INCLUDE_DIRS - the Glib include directories
#  Glib_LIBRARIES - link these to use Glib

# Main include dir
FIND_PATH(GlibBase_INCLUDE_DIR
  NAMES glib.h
  PATHS ${Glib_PKGCONF_INCLUDE_DIRS}
  PATH_SUFFIXES glib-2.0
)

# Glib-related libraries also use a separate config header, which is in lib dir
FIND_PATH(GlibConfig_INCLUDE_DIR
  NAMES glibconfig.h
  PATHS ${Glib_PKGCONF_INCLUDE_DIRS} /usr
  PATH_SUFFIXES lib/x86_64-linux-gnu/glib-2.0/include
)

# Finally the library itself
FIND_LIBRARY(Glib_LIBRARY
  NAMES glib-2.0
  PATHS ${Glib_PKGCONF_LIBRARY_DIRS}
)

set( Glib_INCLUDE_DIR "${GlibBase_INCLUDE_DIR}; ${GlibConfig_INCLUDE_DIR}")
