#include"MainApp.h"

#include<map>
#include"TobiiGlassesSDK.h"

Tobii::GlassesSDK glasses("192.168.71.50");
std::map<int64_t, cv::Mat> images;
int64_t timestamp_offset = 0;

void intHandler(int sig)
{
	glasses.stopLiveStream();
	signal(sig, SIG_IGN);
}

void parse(const std::string& str)
{
	try {
		std::istringstream is(str);
		try {
			JAULA::Value_Complex* data = JAULA::Parser::parseStream(is);
			Tobii::GlassesSDK::JAULA_traverse(data, 0);
		} catch(JAULA::Exception & e) {
			std::cerr << e.getOrigin() << " : " << e.getDetail() << std::endl;
		}
		
	}catch(const std::exception& e) {
		std::cerr << e.what() << std::endl;
	}
}

void video_cb(cv::Mat& image, const int64_t pts)
{
	static const std::string windowName( "TobiiGlassesSDK" );
	static cv::Mat frame;

	
	std::cout << "main.cpp::video_cb Received image: pts=" << pts << "." << std::endl;
	
	//cv::resize( image, frame, cv::Size(800, 600) );
	//cv::imshow( windowName, frame );
		// cv::updateWindow( windowName );
	//cv::waitKey(0);

}

void setTimestamp_offset(std::map<std::string, JAULA::Value*>& syncValue)
{
	timestamp_offset=((JAULA::Value_Number_Int*)syncValue["ts"])->getData()-(((JAULA::Value_Number_Int*)syncValue["pts"])->getData()*10000);
}

void data_cb(std::string& data)
{
	//std::cout << "main.cpp::data_cb Received data: " << data << std::endl;
	/*try {
		std::istringstream is(data);
		try {
			JAULA::Value_Complex * data = JAULA::Parser::parseStream(is);
			//JAULA_traverse(data, 0);
			JAULA::Value::ValueType type = data->getType();
			if(type==JAULA::Value::TYPE_OBJECT) {
				std::map<std::string, JAULA::Value *> values = ((JAULA::Value_Object*)data)->getData();
				if(values["ts"] && values["pts"] && values["pv"]) {
					setTimestamp_offset(values);
					std::cout << "sync message, offset = " << *values["ts"] << "-"<< *values["pts"] << " " << timestamp_offset << std::endl;
				}
				std::cout << "Data message - o:" << *values["ts"] << " s:" << ((JAULA::Value_Number_Int*)values["ts"])->getData()+timestamp_offset << std::endl;
			}
		}catch(JAULA::Exception & e) {
			std::cout << e.getOrigin() << " : " << e.getDetail() << std::endl;
		}
		
	}catch(const std::exception & e) {
		std::cout << e.what() << std::endl;
	}*/
}

void data_filled_cb(Tobii::Data & d)
{
	std::map<int64_t, Tobii::DataRow>::iterator it;
	size_t size = d.bufferData.size();
	// for (it=d.bufferData.begin(); it!=d.bufferData.end(); ++it) {
	// 	if(it->second.check_flags == Tobii::DATAROW_FIXATION_FILLED) {
	//     		std::cout << it->first << ", GP: " << it->second.gazePosition2D[0] << ", " << it->second.gazePosition2D[1] << std::endl;
	// 	}
	// }
	if(size>10) {
		it = d.bufferData.begin();
		std::advance(it, size - 10);
		d.bufferData.erase(d.bufferData.begin(), it);
	}
	// std::cout << "/!\\ Data completely filled /!\\" << std::endl;
	// std::cout << "there are " << d.bufferData.size() << " elements on the buffer." << std::endl;
}

int main(int argc, char ** argv)
{
	struct sigaction act;
	act.sa_handler = intHandler;
	sigaction(SIGINT, &act, NULL);

	glasses.setVideoCallback( &video_cb );
	glasses.setDataCallback(  &data_cb  );
	glasses.setDataFilledCallback(&data_filled_cb);
	if( glasses.discovery(false) )
	{
		glasses.livestream(TOBII_LIVE_ON_WINDOW);
	}
	return 0;
}
