#include "Network.h"
#include <iostream>
#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include <errno.h>

Network::Network() {
#ifdef WINDOWS
	WSAStartup(0x0202, &wsaData);
#endif
}

int Network::portEncode(int port) {
	return htons(port);
}

int Network::makeSocket() {
	int sockfd = -1;
	sockfd = socket(AF_INET, SOCK_DGRAM, 0);
	if (sockfd < 0)
	{
		return sockfd;
	}

	return sockfd;
}

int Network::bindSocket(struct sockaddr_in & dest, int sock) {
	if (bind(sock, (struct sockaddr *)&dest, sizeof(dest))<0) {
		std::cout << "Binding Socket FAILED!" << std::endl;
		if (sock) {
			clearSocket(sock);
		}
		return 0;
	}
	return 1;
}

void Network::configureSockAddr(struct sockaddr_in & sockaddr, const char * inetaddr, int port) {
	memset(&sockaddr, 0, sizeof(struct sockaddr_in));
	sockaddr.sin_family = AF_INET;
	if(inetaddr==NULL)
		sockaddr.sin_addr.s_addr=htonl(INADDR_ANY);
	else
		sockaddr.sin_addr.s_addr=inet_addr(inetaddr);
	sockaddr.sin_port=portEncode(port);
}

int Network::sendUDPTo(struct sockaddr_in & sockaddr, int sockfd, const char * msg) {
	return sendto(sockfd, msg, strlen(msg), 0, (struct sockaddr *)&sockaddr, sizeof(sockaddr));
}

int Network::recvUDPFrom(struct sockaddr_in * sockaddr, int sockfd, std::string & msgout, bool dontwait) {
	char buf[1024];
	int n = 0;
	int flags = 0;
	if(dontwait) {
		flags |= MSG_DONTWAIT;
	}
	socklen_t slen = sizeof(*sockaddr);
	n = recvfrom(sockfd, buf, 1024, flags, (struct sockaddr *)sockaddr, &slen);
	buf[n]=0;
	msgout = std::string(buf);
	return n;
}

void Network::clearSocket(int sock) {
#ifdef WINDOWS
	closesocket(sock)
	WSACleanup();
#else
	//close(sock);
#endif
}

void Network::printErrors() {
	fprintf (stderr, "Network::error %s\n", strerror (errno));
}

#ifdef TEST
int main(int argc, char ** argv) {
	char sendLine[1000];
	std::string recvLine;
	Network network;
	struct sockaddr_in saddr;
	int s = network.makeSocket();
	network.configureSockAddr(saddr, argv[1], atoi(argv[2]));
	while (fgets(sendLine, 1000,stdin) != NULL)
	{
		network.sendUDPTo(saddr, s, sendLine);
		if(network.recvUDPFrom(NULL, s, recvLine)) {
			std::cout << recvLine << std::endl;
		}
	}
	return 0;
}
#endif

#ifdef TEST_SERVER

/* Sample UDP server */

#include <sys/socket.h>
#include <netinet/in.h>
#include <stdio.h>
#include <errno.h>

int main(int argc, char**argv)
{
	struct sockaddr_in saddr,caddr;
	std::string msg;
	Network network;
	int s = network.makeSocket();
	network.configureSockAddr(saddr, argv[1], atoi(argv[2]));
	network.bindSocket(saddr, s);
	while(1)
	{
		if(network.recvUDPFrom(&caddr, s, msg)) {
      			//fprintf (stderr, "%s: error %s\n",
              		// argv[0], strerror (errno));
			std::cout << "Received from network: " << msg << std::endl;
			network.sendUDPTo(caddr, s, msg.c_str());
		}
	}
}

#endif

#ifdef TEST_DISCOVERY

/* Sample UDP server */
// WORKING !!!!!

#include <sys/socket.h>
#include <netinet/in.h>
#include <stdio.h>
#include <errno.h>

int main(int argc, char ** argv) {
	char sendLine[1000];
	std::string msg;
	Network network;
	struct sockaddr_in saddr, saddr_listen, saddr_recv;
	sendLine[0]=0;
	strcpy(sendLine, "{\"type\":\"discover\"}");
	int s = network.makeSocket();
	network.configureSockAddr(saddr, "192.168.71.50", 13006);

	//int srecv = network.makeSocket(srecvaddr);
	network.configureSockAddr(saddr_listen, NULL, 13006);
	network.bindSocket(saddr_listen, s);

	network.sendUDPTo(saddr, s, sendLine);
	//std::cout << "Sent " << sendLine << std::endl;
	std::cout << "Listening..." << std::endl;
	while(1)
	{
		if(network.recvUDPFrom(&saddr_recv, s, msg)) {
			std::cout << "Received from network: " << msg << std::endl;
		}
	}
	return 0;
}
#endif
