#include "Config.h"
#include <fstream>
#include <iostream>
#include <string.h>

Config::Config(const std::string fileName):m_fileName(fileName) {
	char buf[64];
	char sbuf1[64];
	char sbuf2[64];
	int i=0;

	std::ifstream ifs;
	std::map<std::string, std::string>::iterator it;

	ifs.open(m_fileName.c_str());
	while (ifs.good()) {
		memset(buf, 0, 64);
		memset(sbuf1, 0, 64);
		memset(sbuf2, 0, 64);
		ifs.getline(buf, 64);
		if(ifs.good()) {
			//sscanf(buf,"%[a-zA-Z0-9]s=%[a-zA-Z0-9]s\n", sbuf1, sbuf2);
			sscanf(buf,"%[^=]=%s\n", sbuf1, sbuf2);
			m_map.insert(
				std::pair<std::string,std::string>(
					std::string(sbuf1),
					std::string(sbuf2)
				)
			);
		}

  	}
	ifs.close();
}

const std::string Config::getValue(const std::string key) {
	std::map<std::string, std::string>::iterator it = m_map.find(key);
	if(it!=m_map.end())
		return it->second;
	else
		return std::string("None");
}

void Config::print() {
	std::map<std::string, std::string>::iterator it;
	for(it=m_map.begin();it!=m_map.end();++it) {
		std::cout << (*it).first << ":" << (*it).second << std::endl;
	}
}
