#include <cstdlib>
#include <iostream>
#include <iomanip>
#include <fstream>
#include <string>
#include <vector>
#include <algorithm>
#include <signal.h>

#include "opencv2/highgui/highgui.hpp"
#include <opencv2/imgproc/imgproc.hpp>
#include <opencv2/contrib/contrib.hpp>
//#include <opencv2/core/core.hpp>
#include <opencv2/gpu/gpu.hpp> // GPU structures and methods 

#include "ReaderEyeTrackerResults.hpp"
//#include "ReaderEyeTrackerResultsTR.hpp"

#define WE_HAVE_TOBII
#ifdef WE_HAVE_TOBII
	#include "TobiiGlassesSDK.h"
	Tobii::GlassesSDK * glasses = NULL;   
#else
	#include "TobiiGlassesSDKParser.h"
	Tobii::GlassesSDKFile * glasses = NULL;   
#endif



#define fps 25
#define width 1920 //FRAME_WIDTH
#define height 1080 //FRAME_HEIGHT

const char* result_wooding_folder;
void usage(const char *cmd);
cv::Mat getGaussianKernelWithCenter(int length, int center, double sigma);
void wooding_compute (std::vector< std::pair<double,double> > coordinates , std::vector<double> sigma , int nbFrames_sizebuffer , const char * result_wooding_folder);

// Tobii necessary functions (for now)
void intHandler(int sig);
// FALSE, TEST FOR SYNCHRONIZATION
int64_t setTimestamp_offset(int64_t ts, int64_t pts);
void data_filled_cb(Tobii::Data & d, unsigned int sizeBuffer, char flag);

int main(int argc, char **argv)
{
//verification des parametre d'entrees dans la ligne de commande
	if((argc != 4)&&(argc != 5)&&(argc!=3)) usage(argv[0]);
	
//verification du video
	if (argc == 4)
	{
		cv::VideoCapture video(argv[2]);
		if(!video.isOpened()) 
		{
			std::cerr << "Erreur de lecture du fichier video: " << argv[2] << std::endl;
			return EXIT_FAILURE;
		}
		
		//caracteristiques du video
		int nbFrames = video.get(CV_CAP_PROP_FRAME_COUNT);//nombre de frames dans video
std::cout <<nbFrames<<std::endl;
		std::cout <<"Nb Frames : "<<nbFrames<< std::endl;

				// initialise result_files
				std::vector<ReaderEyeTrackerResults*> resultFiles;
				std::vector<ReaderEyeTrackerResults*> resultFiles2;
	
				resultFiles.push_back(new ReaderEyeTrackerResults(argv [1],fps, width, height));
				resultFiles2.push_back(new ReaderEyeTrackerResults(argv [1],fps, width, height));
	
				//Gaussian parameters
				std::vector<double> sigma = resultFiles2[0]-> calculSigma ();

				// Read eye positions 40
				std::vector< std::pair<double,double> > coordinates = resultFiles[0]->readResultsNewFrame();//resultFiles[0] : 1 seul fichier d'enregistrement Tobii
				int coordinates_size = coordinates.size();
				std::cout << nbFrames - coordinates_size<<" Frame noire car le langueur du video float (avec ,) et le temps dans le fichier d'enregistrement int  "<< std::endl;
				

				wooding_compute (coordinates ,  sigma , nbFrames,argv[3]);

	}

	

	#ifdef WE_HAVE_TOBII
	//if (argc == 3)
	if (argc == 3)/***************Mariem***********/
	{
		std::cout << "hello" << std::endl;
		struct sigaction act;
		char glassesIPAddress[64];
		memset(glassesIPAddress, 0, 64*sizeof(char));
		act.sa_handler = intHandler;
		sigaction(SIGINT, &act, NULL);
		strncpy(glassesIPAddress, argv[1], strlen(argv[1]));
		unsigned int sizeBuffer = atoi(argv[2]);
		glasses = new Tobii::GlassesSDK(glassesIPAddress, sizeBuffer);
		//glasses = new Tobii::GlassesSDK(glassesIPAddress, sizeBuffer,result_wooding_folder , TR);/***************Mariem***********/
		glasses->setDataFilledCallback(&data_filled_cb);
		if(glasses->discovery(true)) {
			//glasses->livestream(TOBII_LIVE_ON_WINDOW);
			glasses->livestream(TOBII_LIVE_ON_OPENCV);
		}
		else
			std::cerr << "could not find glasses on network" << std::endl;
		delete glasses;
	}
	#else
	//if (argc == 3)
	if (argc == 5)
	{
		char fileName[256];
		memset(fileName, 0, 256*sizeof(char));
		strncpy(fileName, argv[1], strlen(argv[1]));
		unsigned int sizeBuffer = atoi(argv[2]);
		std::string result_wooding_folder = argv[3];/***************Mariem***********/
		bool TR = strcmp(argv[4],"true")==0;
		glasses = new Tobii::GlassesSDKFile(fileName, sizeBuffer);//,result_wooding_folder, TR);/***************Mariem***********/
		
		glasses->setDataFilledCallback(&data_filled_cb);
		if(glasses->discovery(true)) {
			glasses->livestream(TOBII_LIVE_ON_FILE);
			//glasses->livestream(TOBII_LIVE_ON_OPENCV);
		}
		delete glasses;
	}
	#endif
	return EXIT_SUCCESS;
}

//Les fonctions

//fonction pour la verification de la ligne de commande
void usage(const char *cmd)
{
	std::cerr << "Usage : " << cmd << " <EyeTracker-file> <input_video> <output_folder>" << std::endl;
	std::cerr << "Or usage TR : " << cmd << " <Tobii IP address> <Buffer size>" << std::endl;
	std::cerr << "Or : " << cmd << " <Tobii fileName> <Buffer size> <true>, only if the binary is compiled with the define \"WE_HAVE_TOBII\"" << std::endl;
	exit(EXIT_FAILURE);
}


//appliquer le filtre Gaussian
cv::Mat getGaussianKernelWithCenter(int length, int center, double sigma)
{
	cv::Mat auxKernel =  cv::getGaussianKernel(length*3, sigma, CV_32F);
	cv::Mat gaussianKernel = auxKernel.rowRange(length + (length/2-center), 2*length + (length/2-center));

	return gaussianKernel;
}

//Wooding_Compute
void wooding_compute (std::vector< std::pair<double,double> > coordinates , std::vector<double> sigma , int nbFrames_sizebuffer ,const char * result_wooding_folder)
{
	cv::Mat mix;
	double minVal; 
	double maxVal; 
	cv::Point minLoc; 
	cv::Point maxLoc;

	std::string extension = ".png";
	std::string title;
	
	int currentProcessedFrames=0;
	//int stepProgressDisplay=100;
	int coordinates_size = coordinates.size();


	while (currentProcessedFrames < nbFrames_sizebuffer) 
	{
		//video >> trame;
		cv::Mat kernelX;
		cv::Mat kernelY;
		cv::Mat kernelXY = cv::Mat::zeros(height, width, CV_32F);//Matrice de taille height*width avec des zero (noir)

		cv::gpu::GpuMat  kernelY_gpu_trans,kernelY_gpu,kernelXY_gpu;
		cv::Mat kernelY_trans;

		//std::cout << "frame " <<currentProcessedFrames <<"/" << nbFrames_sizebuffer<< std::endl;

			// Create Gaussian kernels
			
				//cv::Mat atom_image = cv::Mat::zeros(height, width, CV_8UC3 );

				//for (int i=0; i < coordinates.size(); i++)
				if ( currentProcessedFrames < coordinates_size)
				{
					cv::Point coord(coordinates[currentProcessedFrames].first,coordinates[currentProcessedFrames].second);
					//cv::Point coord(coordinates[i].first,coordinates[i].second);
					//cv::circle(atom_image, coord, 100, cv::Scalar(94.0, 206.0, 165.0, 0.0));
					

					kernelX = getGaussianKernelWithCenter(height, coordinates[currentProcessedFrames].second, sigma[currentProcessedFrames]);
					kernelY = getGaussianKernelWithCenter(width, coordinates[currentProcessedFrames].first, sigma[currentProcessedFrames]);

					//GPU
					kernelY_gpu.upload(kernelY);
					cv::gpu::transpose(kernelY_gpu,kernelY_gpu_trans);//kernelY.t()					
					kernelY_gpu_trans.download(kernelY_trans);

					//old
					//kernelXY += kernelX * kernelY.t();//inutile + car a chaque fois initialisation de la Matrice kernelXY par des zeros
					kernelXY = kernelX * kernelY_trans;
					cv::circle(kernelXY, coord, 10, cv::Scalar(0x0,0x0,0xff));

				}

		
		kernelXY_gpu.upload(kernelXY);

		//old
		//minMaxLoc( kernelXY, &minVal, &maxVal, &minLoc, &maxLoc, cv::Mat());//Finds the global minimum and maximum in an array
		//GPU
		cv::gpu::minMaxLoc (kernelXY_gpu, &minVal, &maxVal, &minLoc, &maxLoc, cv::gpu::GpuMat());//Finds the global minimum and maximum in an array

		//old
		//kernelXY=kernelXY *(1/maxVal) *255;
		//kernelXY.convertTo(kernelXY,CV_8U);
		//GPU
		kernelXY_gpu.convertTo(kernelXY_gpu, kernelXY_gpu.type(),(255/maxVal)); // kernelXY_gpu=kernelXY_gpu *(1/maxVal) *255;
		kernelXY_gpu.convertTo(kernelXY_gpu,CV_8U);


		//cv::applyColorMap(kernelXY, kernelXY, cv::COLORMAP_JET);
		
		// old code
		//mix = kernelXY;
		//GPU
		kernelXY_gpu.download(mix);// download kernelXY_gpu to mix

		//cv::imshow("points", atom_image);

		//save saliency file
		std::ostringstream count_str;
		count_str << "/" << std::setw(8) << std::setfill('0') << currentProcessedFrames;
		title=result_wooding_folder+count_str.str()+extension;

		cv::imwrite(title, mix);
		

		// Show Progress
		currentProcessedFrames++;
		/*if (currentProcessedFrames % stepProgressDisplay == 0)
		{
			std::cout << currentProcessedFrames << "/" <<  nbFrames << std::endl;
		}
		*/
		//cv::imshow("mix", mix);
		//cv::imshow("trame", trame);
		//cv::imshow("gauss", kernelXY);
		//cv::waitKey(0);

		

	}

	//std::cout << "Finished creating files in " << result_wooding_folder << std::endl;
	std::cout << "Finished creating "<< nbFrames_sizebuffer << "Wooding frame in " << result_wooding_folder << std::endl;


}



/************************* SDK Fonction ***************************/
void intHandler(int sig) {
	glasses->stopLiveStream();
	signal(sig, SIG_IGN);
}

// FALSE, TEST FOR SYNCHRONIZATION
int64_t setTimestamp_offset(int64_t ts, int64_t pts) {
	return ts-pts*10000;
}

bool isFirstTimeStamp = false;
int64_t firstTimestamp= 0;

void data_filled_cb(Tobii::Data & d, unsigned int sizeBuffer, char flag) {
	static int trackingcount = 0;
	static int framecount = 0;
	
	if(flag & Tobii::DATA_IS_TRACKING) {

		trackingcount++;
		std::map<int64_t, Tobii::DataRow>::iterator it;
		size_t size = d.bufferData.size();

//std::vector<double,double> interpolated = ReaderEyeTrackerResults::interpolationFrame (d);

		if (isFirstTimeStamp==false)
		{
		    isFirstTimeStamp=true;
		    firstTimestamp=d.bufferData.begin()->first;
		    //std::cout << "firstTimestamp : "<< firstTimestamp<< std::endl;	
		}

		if (trackingcount % sizeBuffer ==0) 
		{

			std::vector<double> time_stamp_frame;
			std::vector<double> time_stamp;
			std::vector< std::pair<double,double> > coordinates;
			std::vector<double> sigma;
			double aux_distance = 1600;// en cas ou tout les valeurs de du buffer a zeros


			std::vector< std::pair<double,double> > coordinates_TR;
			std::vector<double> sigma_TR;



			std::cout << "###############################" << std::endl;
			for (it=d.bufferData.begin(); it!=d.bufferData.end(); ++it) {

/********************** Timestamp *******************************/			
//std::cout << (it->first -firstTimestamp)/1000 << std::endl;
		//fprintf(stdout, "%x\n", it->second.check_flags);
				if(it->second.check_flags == Tobii::DATAROW_FIXATION_FILLED) {

					/********************** Timestamp *******************************/	
					//std::cout << (it->first -firstTimestamp)/1000 << std::endl;

					/********************** Gaze Point X Y 2D ****************************/
					std::cout << (it->first -firstTimestamp)/1000 << ", Gaze Point ( " << it->second.gazePosition2D[0] << " , " << it->second.gazePosition2D[1]<< " )"<< std::endl;


					/********************** Gaze Position en 3D **************************/
					//std::cout << "Gaze Position 3D  ( " << it->second.gazePosition3D[0] << " , " << it->second.gazePosition3D[1] << " , " << it->second.gazePosition3D[2]<< " )"<< std::endl;

					//Gaze Direction Eye Left
					//std::cout <<"GD_left ( " << it->second.left.gazeDirection[0] << " , " << it->second.left.gazeDirection[1]  << " , " << it->second.left.gazeDirection[2] << " )"<< std::endl;

					//Gaze Direction Eye Right
					//std::cout << "GD_right ( " << it->second.right.gazeDirection[0] << " , " << it->second.right.gazeDirection[1]  << " , " << it->second.right.gazeDirection[2]<< " )"<< std::endl;

					//Pupille centere Eye Right
					//std::cout <<"pupilCenter ( " << it->second.right.pupilCenter[0] << " , " << it->second.right.pupilCenter[1]  << " , " << it->second.right.pupilCenter[2]<< " )"<< std::endl;

					double Distance_cible = glasses->claculDistanceEspace (it->second.gazePosition3D[0],0,it->second.gazePosition3D[1],0,it->second.gazePosition3D[2],0);
					std::cout<<"Distance :"<<Distance_cible<< std::endl;

					if (Distance_cible != 0)
					{
						double Sigma = glasses->calculSigma (Distance_cible);
						//std::cout<<"Sigma :"<< Sigma<< std::endl;
						sigma.push_back(Sigma);
						//time_stamp.push_back((it->first -firstTimestamp)/1000);
						//std::cout<<"time_stamp :"<< (it->first -firstTimestamp)/1000 << std::endl;
						aux_distance=Distance_cible;

					}
					else
					{
						double Sigma = glasses->calculSigma (aux_distance);
						//std::cout<<"Sigma :"<< Sigma<< std::endl;
						sigma.push_back(Sigma);
						std::cout<<"aux_distance:"<<aux_distance<< std::endl;
					}

					coordinates.push_back({it->second.gazePosition2D[0], it->second.gazePosition2D[1]});
					time_stamp_frame.push_back((it->first -firstTimestamp)/1000);

				}


			}
			//std::cout <<sigma.size()<<std::endl;
			//glasses->interpolationSigmaTR (sigma,time_stamp_frame);
			//glasses->interpolationFrameTR (time_stamp_frame,coordinates);
			sigma_TR = glasses->interpolationSigmaTR (sigma,time_stamp_frame);
			coordinates_TR =glasses->interpolationFrameTR (time_stamp_frame,coordinates);


			wooding_compute (coordinates_TR , sigma_TR ,coordinates_TR.size() ,result_wooding_folder);


		}

		// cleaning the data buffer in order to keep only sizeBuffer elements
		if(size> sizeBuffer-1) {
			it = d.bufferData.begin();
			std::advance(it,size - sizeBuffer+1);
			d.bufferData.erase(d.bufferData.begin(), it);
		}

		//std::cout << "/!\\ Data completely filled /!\\" << std::endl;
		//std::cout << "there are " << d.bufferData.size() << " elements on the data buffer." << std::endl;
	}else if(flag & Tobii::DATA_IS_FRAME){
		framecount++;
		std::map<int64_t, Tobii::DataRowFrame>::iterator it;
		size_t size = d.bufferFrames.size();
		if (isFirstTimeStamp==false)
		{
		    isFirstTimeStamp=true;
		    firstTimestamp=d.bufferFrames.begin()->first;
		    //std::cout << "firstTimestamp : "<< firstTimestamp<< std::endl;	
		}
		for (it=d.bufferFrames.begin(); it!=d.bufferFrames.end(); ++it) {
		//	std::cout << "frame pts: " << it->first << std::endl;
			std::cout << (it->first -firstTimestamp)/1000000000 << std::endl;
		}
		// cleaning the frames buffer in order to keep only sizeBuffer elements
		if(size>sizeBuffer-1) {
			it = d.bufferFrames.begin();
			std::advance(it, size - sizeBuffer+1);
			d.bufferFrames.erase(d.bufferFrames.begin(), it);
		}
		//std::cout << "there are " << d.bufferFrames.size() << " elements on the frame buffer." << std::endl;
		/*std::map<int64_t,Tobii::DataRowFrame>::reverse_iterator rit = d.bufferFrames.rbegin();
		// Save the frame into a file
		char buf[64];
		sprintf(buf, "frame%08d.jpg", framecount);
		cv::imwrite(buf, rit->second.frame);*/

	}else if(flag & Tobii::DATA_IS_SYNC) { // more or less every seconds
		//std::cout << "data fps: " << trackingcount << ", video fps: " << framecount << std::endl;
		//std::cout << "Sync packet received." << std::endl;
		// do something cool about sync, or just know that there is a new syncing data.
	
}
}


