#include "TobiiGlassesSDKParser.h"

#include <iostream>
#include <vector>
#include <sstream>
#include <algorithm>
#include <string.h>
#include <time.h>
#include <exception>
#include <unistd.h>
#include <fcntl.h>
#include <fstream>

#include "spline.h"

//pour calcul de sigma
#define PI 3.14159265
#define ImResHor 1080 /*resolution horizontal de la caméra*/
#define ImResVert 1920 /*resolution vertical de la caméra*/
#define alpha 2  /*projection de la fovéa 2°*/
#define beta 24  /*l'angle en x d'ouverture de la caméra*/
#define A 1600 /*ponderation de la largeur de la carte de saillance en fonction de la distance*/
#define Sigma_pixel_initial ImResHor/2 * tan (alpha * PI / 180.0) /tan (beta * PI / 180.0)



Tobii::GlassesSDKFile::GlassesSDKFile(const char * fileName, unsigned int bufferSize)
:m_fileName(fileName),
m_isRunning(false),
m_dataCallback(NULL),
m_dataFilledCallback(NULL),
 m_data_size(bufferSize) {
	m_data.lastSyncTS = -1;
	m_data.lastSyncPTS = -1;
}

/***************Mariem**********************/
Tobii::GlassesSDKFile::GlassesSDKFile(const char * fileName, unsigned int bufferSize, const char * result_wooding_folder ,bool TR)
:m_fileName(fileName),
m_result_wooding_folder (result_wooding_folder),
m_TR(TR),
m_isRunning(false),
m_dataCallback(NULL),
m_dataFilledCallback(NULL),
 m_data_size(bufferSize) {
	m_data.lastSyncTS = -1;
	m_data.lastSyncPTS = -1;
}


Tobii::GlassesSDKFile::~GlassesSDKFile() {
	std::cout << "Tobii::GlassesSDKFile shutdown." << std::endl;
}

void Tobii::GlassesSDKFile::setDataCallback(std::function< void(std::string &) > func) {
	m_dataCallback = func;
}

void Tobii::GlassesSDKFile::setDataFilledCallback(std::function<void(Data & data, unsigned int sizeBuffer, char flag)> func) {
	m_dataFilledCallback = func;
}

bool Tobii::GlassesSDKFile::discovery(bool setSyncDate) {
	return true;
}

void Tobii::GlassesSDKFile::onDataArrived(const std::string & dataRecv) {
	try {
		std::istringstream is(dataRecv);
		try {
			JAULA::Value_Complex * data = JAULA::Parser::parseStream(is);
			//JAULA_traverse(data, 0);
			JAULA::Value::ValueType type = data->getType();
			// check if the data is an object, else, this is not tracking data
			if(type==JAULA::Value::TYPE_OBJECT) {
				std::map<int64_t, DataRow>::iterator it;
				std::map<std::string, JAULA::Value *> values = ((JAULA::Value_Object*)data)->getData();
				if(values["ts"] && !values["vts"]) {
					if(values["pts"]) {
						m_data.lastSyncTS = ((JAULA::Value_Number_Int*)values["ts"])->getData();
						m_data.lastSyncPTS = ((JAULA::Value_Number_Int*)values["pts"])->getData();
						m_dataFilledCallback(m_data,  m_data_size, DATA_IS_SYNC);
					}else{
						int64_t ts=((JAULA::Value_Number_Int*)values["ts"])->getData();
						it=m_data.bufferData.find(ts);
						// check if there is already data within the buffer with that value, if not we will create it.
						if(it==m_data.bufferData.end()) {
							it=m_data.bufferData.insert(std::pair<int64_t, DataRow>(ts, DataRow())).first;
							it->second.check_flags = 0x0000;
						}
						// eye related values
						if(values["eye"]) {
							// checking the eye to modify
							Eye * e = NULL;
							short flag = 0x0001;
							if(((JAULA::Value_String*)values["eye"])->getData().compare("right")) {
								e = &(it->second.right);
								flag = flag << 3;
							}else{
								e = &(it->second.left);
							}

							// eye checks
							if(values["pc"] && e!=NULL) {
								std::list<JAULA::Value*>::const_iterator itpc = ((JAULA::Value_Array*)values["pc"])->getData().begin();
								e->pupilCenter[0] = ((JAULA::Value_Number*)*itpc)->getData();
								itpc = std::next(((JAULA::Value_Array*)values["pc"])->getData().begin(), 1);
								e->pupilCenter[1] = ((JAULA::Value_Number*)*itpc)->getData();
								itpc = std::next(((JAULA::Value_Array*)values["pc"])->getData().begin(), 2);
								e->pupilCenter[2] = ((JAULA::Value_Number*)*itpc)->getData();
								it->second.check_flags |= flag;
							}else if(values["pd"] && e!=NULL) {
								e->pupilDiameter = ((JAULA::Value_Number*)values["pd"])->getData();
								it->second.check_flags |= (flag<<1);
							}else if(values["gd"]) {
								std::list<JAULA::Value*>::const_iterator itpd = ((JAULA::Value_Array*)values["gd"])->getData().begin();
								e->gazeDirection[0] = ((JAULA::Value_Number*)*itpd)->getData();
								itpd = std::next(((JAULA::Value_Array*)values["gd"])->getData().begin(), 1);
								e->gazeDirection[1] = ((JAULA::Value_Number*)*itpd)->getData();
								itpd = std::next(((JAULA::Value_Array*)values["gd"])->getData().begin(), 2);
								e->gazeDirection[2] = ((JAULA::Value_Number*)*itpd)->getData();
								it->second.check_flags |= (flag<<2);
							}
						}
						// gaze and inertial related values
						if(values["gp"]) {
							std::list<JAULA::Value*>::const_iterator itgp = ((JAULA::Value_Array*)values["gp"])->getData().begin();
							it->second.gazePosition2D[0] = ((JAULA::Value_Number*)*itgp)->getData();
							itgp = std::next(((JAULA::Value_Array*)values["gp"])->getData().begin(), 1);
							it->second.gazePosition2D[1] = ((JAULA::Value_Number*)*itgp)->getData();
							it->second.check_flags |= DATAROW_GP2_FILLED;
						}else if(values["gp3"]) {
							std::list<JAULA::Value*>::const_iterator itgp3 = ((JAULA::Value_Array*)values["gp3"])->getData().begin();
							it->second.gazePosition3D[0] = ((JAULA::Value_Number*)*itgp3)->getData();
							itgp3 = std::next(((JAULA::Value_Array*)values["gp3"])->getData().begin(), 1);
							it->second.gazePosition3D[1] = ((JAULA::Value_Number*)*itgp3)->getData();
							itgp3 = std::next(((JAULA::Value_Array*)values["gp3"])->getData().begin(), 2);
							it->second.gazePosition3D[2] = ((JAULA::Value_Number*)*itgp3)->getData();
							it->second.check_flags |= DATAROW_GP3_FILLED;
						}else if(values["gy"]) {
							std::list<JAULA::Value*>::const_iterator itgy = ((JAULA::Value_Array*)values["gy"])->getData().begin();
							it->second.gyroscope[0] = ((JAULA::Value_Number*)*itgy)->getData();
							itgy = std::next(((JAULA::Value_Array*)values["gy"])->getData().begin(), 1);
							it->second.gyroscope[1] = ((JAULA::Value_Number*)*itgy)->getData();
							itgy = std::next(((JAULA::Value_Array*)values["gy"])->getData().begin(), 2);
							it->second.gyroscope[2] = ((JAULA::Value_Number*)*itgy)->getData();
							it->second.check_flags |= DATAROW_GY_FILLED;
						}else if(values["ac"]) {
							std::list<JAULA::Value*>::const_iterator itac = ((JAULA::Value_Array*)values["ac"])->getData().begin();
							it->second.accelerometer[0] = ((JAULA::Value_Number*)*itac)->getData();
							itac = std::next(((JAULA::Value_Array*)values["ac"])->getData().begin(), 1);
							it->second.accelerometer[1] = ((JAULA::Value_Number*)*itac)->getData();
							itac = std::next(((JAULA::Value_Array*)values["ac"])->getData().begin(), 2);
							it->second.accelerometer[2] = ((JAULA::Value_Number*)*itac)->getData();
							it->second.check_flags |= DATAROW_AC_FILLED;
						}
						if(it->second.check_flags == DATAROW_FIXATION_FILLED && m_dataFilledCallback!=NULL) {
							m_dataFilledCallback(m_data,  m_data_size, DATA_IS_TRACKING);
						}
					}
				}
			}
		}catch(JAULA::Exception & e) {
			std::cout << e.getOrigin() << " : " << e.getDetail() << std::endl;
		}
		
	}catch(const std::exception & e) {
		std::cout << e.what() << std::endl;
	}
}

void Tobii::GlassesSDKFile::livestream(int flag) {
	std::ifstream infile(m_fileName);
	std::string line;
	m_isRunning = true;
	while (std::getline(infile, line) && m_isRunning)
	{
		onDataArrived(line);
	}
}

uint64_t Tobii::GlassesSDKFile::getTimeStamp() {
    /*struct timeval tv;
    gettimeofday(&tv,NULL);
    return tv.tv_sec*(uint64_t)1000000+tv.tv_usec;*/
	return 0;
}

void Tobii::GlassesSDKFile::timestamp2date(uint64_t t, std::string & date) {
	/*// format  "date":"2014-09-24T12:13:14Z"
	char buf[32];
	uint64_t ms = (t-t%1000)/1000;
	uint64_t timestamp = (ms-ms%1000)/1000;
	memset(buf, 0, 32);
	strftime(buf, 32, "%Y-%m-%dT%H:%M:%SZ", localtime ((time_t*)&timestamp));
	date = std::string(buf);*/
	return;
}

void Tobii::GlassesSDKFile::date2timestamp(const std::string & datestr, uint64_t * t) {
	/*struct tm tm;
	if ( strptime(datestr.c_str(), "%Y-%m-%d %H:%M:%S", &tm) != NULL ) {
		*t = (uint64_t)mktime(&tm);
	}*/
}

bool Tobii::GlassesSDKFile::calibrate(const std::string & calibration_id) {
	return true;
}

void Tobii::GlassesSDKFile::stopLiveStream() {
	m_isRunning = false;
}

/***************************Mariem***********************************/
//calcul de la distance entre le sujet et le cible
double 
Tobii::GlassesSDKFile::claculDistanceEspace(double x1,double x2, double y1, double y2,double z1 ,double z2)
{
return (sqrt ((x2-x1)*(x2-x1)+(y2-y1)*(y2-y1)+(z2-z1)*(z2-z1)));
}

// calcul parametre Gaussian : sigma 
double 
Tobii::GlassesSDKFile::calculSigma (double Distance_cible)
{
return (Sigma_pixel_initial * A /(Distance_cible + 0.00001));
}

//Fonction interpolation GazePoint pour frame 40 ms
int m=0;
std::vector< std::pair<double,double> >
//void
Tobii::GlassesSDKFile::interpolationFrameTR (std::vector<double> time_stamp_frame, std::vector< std::pair<double,double> > coordinates)
{
	std::vector<double> XX,YY,TT;
	std::vector<double> time_mul_frame;
	std::vector< std::pair<double,double> > coordinates_interpol_frame;
 	
	do
	{
	time_mul_frame.push_back(m);
	//std::cout <<"time_mul_frame : "<< m<<std::endl;
	m=m+40;
	}while (m < time_stamp_frame[time_stamp_frame.size()-1] +40);

	for (int i=0; i < coordinates.size(); i++)
	{
          if (coordinates[i].first != 0)
	  {
            XX.push_back(coordinates[i].first);
	    YY.push_back(coordinates[i].second);
	  }  
	   else
 	  {
		if (coordinates[i-1].first !=0)
		{
		XX.push_back(coordinates[i-1].first);
		YY.push_back(coordinates[i-1].second);
		}
		else
			//if (coordinates[i+1].first !=0)
			//{
			XX.push_back(coordinates[i+1].first);
			YY.push_back(coordinates[i+1].second);
			//}
			//else //en cas ou tout les valeurs zero il faut avoir une valeur aux
			//{
			//XX.push_back(coordinates[i+1].first);
			//YY.push_back(coordinates[i+1].second);
			//}

	  }      
	}

	tk::spline s1;
	tk::spline s2;
   	s1.set_points(time_stamp_frame,XX);
   	s2.set_points(time_stamp_frame,YY); 

	for (int i=0; i <time_mul_frame.size(); i++)
	{
		coordinates_interpol_frame.push_back({s1(time_mul_frame[i]), s2(time_mul_frame[i])});
		std::cout<< "coordinates_interpol  : " <<time_mul_frame[i]  <<"    (" <<s1(time_mul_frame[i])<<"   ,	"<<s2(time_mul_frame[i]) <<")"<<std::endl;
	}
	
return coordinates_interpol_frame;
}


int n=0;
int j=0;
//Fonction interpolation sigma frame 40
std::vector<double>
//void
Tobii::GlassesSDKFile::interpolationSigmaTR (std::vector<double> sigma , std::vector<double> time_stamp)
{	
	std::vector<double> time_mul_frame;
	std::vector<double> sigma_interpo;

	do
	{
	time_mul_frame.push_back(n);
	//std::cout <<"time interpo  "<< n<<std::endl;
	n=n+40;
	}while (n < time_stamp[time_stamp.size()-1] +40);//last time stamp

	//std::cout <<"derniere time stamp  "<< time_stamp[time_stamp.size()-1]<<std::endl;
	
	tk::spline s1;
	s1.set_points(time_stamp,sigma);//tracer un courbe (time,sigma)

	for (int i=0; i < time_mul_frame.size(); i++)
	{
	sigma_interpo.push_back({s1(time_mul_frame[i])});
		if (sigma_interpo [j]<= 0)//il faut sigma soit positive
			sigma_interpo [j]= sigma_interpo [j-1];//remplacer les valeurs negative par la valeurs precedente (ou bien la moyenne des deux valeurs (avant apres))
	std::cout <<"sigma interpo  : "<< s1(time_mul_frame[i]) <<std::endl;
	}

	
return sigma_interpo;
}



